-------------------------------------------------------------------------------
--                                                     Copyright 1994        --
--                      (C)    Georgia Tech Research Corporation (GTRC).     --
--                                                   All rights reserved.    --
--                                                                           --
--  For non-commercial use                                                   --
--  provided that notice of this copyright is included at the beginning of   --
--  the software, the software may be copied, in its entirety without        --
--  alteration or as altered by (1) adding text that is clearly marked as an --
--  insertion; (2) shading or highlighting existing text; (3) deleting       --
--  examples.  This header must be preserved intact.                         --
--                                                                           --
--  Distribution authorized for non-commercial use to private individuals    --
--  or enterprises eligible                                                  --
--  to obtain export-controlled technical data in accordance with            --
--  regulations implementing 10 U.S.C. 1400 as of 31 March 1987.  Other      --
--  requests must be referred to the director, Advanced Research Projects    --
--  Agency.                                                                  --
--                                                                           --
--  This material may be reproduced by or for the U.S. Government pursuant   --
--  to the copyright license under the clause at DFARS 252.227-7013 (Oct 88) --
--                                                                           --
--  This work sponsored by US government under the following                 --
--  CONTRACT NUMBERS: Air Force - F33615-94C-1493                            --
--  RASSP Technology Base program, 1994-1997 to GTRC/DSP Laboratory,         --
--  Georgia Tech - Electrical and Computer Engineering (PI Dr. V. Madisetti) --
--  vkm@ee.gatech.edu, Fax: 404-853-9171.                                    --
--                                                                           --
--  For permission/license to include in a commercial product or for-profit  --
--  use in any form, please  contact,                                        --
--  Dr. Barry Rosenberg                 barry.rosenberg@gtrc.gatech.edu      --
--  Director - Office of Tech Licensing                                      --
--  Off Acad &  Res Support-GTRC 0415                                        --
--  Centennial Research Bldg                                                 --
--  Georgia Tech, Atlanta, GA 30332-0415,  404-894-6287                      --
--  No warranty as to its suitability or                                     --
--  mechantability is implied or stated.                                     --
--                                                                           --
-------------------------------------------------------------------------------
-------------------------------------------------------------------
-- Title:               1-FIR Tap not Muxed
-- Path			/romdhane/TOP/VHDL/VHDL_compass
-- Filename:            cell1.vhd  
-- Written by           M.S. Ben Romdhane
-------------------------------------------------------------------

use WORK.passpara.all;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
 
library COMPASS_LIB;
use COMPASS_LIB.COMPASS.ALL;

 
entity cell1 is

    port (datain : in bit_vector(P downto 0);
           clk, bank, en_REG1, en_REG2, en_output : in bit;
           coef : in bit_vector(P downto 0);
           acc : in bit_vector(M  downto 0);
           dataout : out bit_vector(M  downto 0) );
end cell1;
 
architecture behave OF cell1 is
 
signal REG1 : bit_vector (P  downto 0);
signal REG2 : bit_vector (P downto 0);
 
begin
        process(clk)
 
-- declaring the variables:
--------------------------
      variable mul : bit_vector (L downto 0);
      variable tmp1 : bit_vector (P downto 0);
      variable mul1 : bit_vector (M downto 0);
      variable tmp : bit_vector (M downto 0);
 
        begin 
        if clk'event and clk = '1' then
		
		if en_REG1= '1' then
                    REG1 <= coef;
		end if;
		if en_REG2= '1' then
                    REG2 <= coef;
		end if;

                tmp := acc; 

                if bank = '1' then
		    tmp1 := REG1;
		else
		    tmp1 := REG2; 
		end if;
		
		mul := datain * tmp1;
                
		mul1 := sign_extend(mul,M+1);
		
		if en_output = '1' then
                dataout  <= mul1 + tmp;
		end if; 
	end if;
        end process;
end behave;

