-------------------------------------------------------------------------------
--                                                     Copyright 1994        --
--                      (C)    Georgia Tech Research Corporation (GTRC).     --
--                                                   All rights reserved.    --
--                                                                           --
--  For non-commercial use                                                   --
--  provided that notice of this copyright is included at the beginning of   --
--  the software, the software may be copied, in its entirety without        --
--  alteration or as altered by (1) adding text that is clearly marked as an --
--  insertion; (2) shading or highlighting existing text; (3) deleting       --
--  examples.  This header must be preserved intact.                         --
--                                                                           --
--  Distribution authorized for non-commercial use to private individuals    --
--  or enterprises eligible                                                  --
--  to obtain export-controlled technical data in accordance with            --
--  regulations implementing 10 U.S.C. 1400 as of 31 March 1987.  Other      --
--  requests must be referred to the director, Advanced Research Projects    --
--  Agency.                                                                  --
--                                                                           --
--  This material may be reproduced by or for the U.S. Government pursuant   --
--  to the copyright license under the clause at DFARS 252.227-7013 (Oct 88) --
--                                                                           --
--  This work sponsored by US government under the following                 --
--  CONTRACT NUMBERS: Air Force - F33615-94C-1493                            --
--  RASSP Technology Base program, 1994-1997 to GTRC/DSP Laboratory,         --
--  Georgia Tech - Electrical and Computer Engineering (PI Dr. V. Madisetti) --
--  vkm@ee.gatech.edu, Fax: 404-853-9171.                                    --
--                                                                           --
--  For permission/license to include in a commercial product or for-profit  --
--  use in any form, please  contact,                                        --
--  Dr. Barry Rosenberg                 barry.rosenberg@gtrc.gatech.edu      --
--  Director - Office of Tech Licensing                                      --
--  Off Acad &  Res Support-GTRC 0415                                        --
--  Centennial Research Bldg                                                 --
--  Georgia Tech, Atlanta, GA 30332-0415,  404-894-6287                      --
--  No warranty as to its suitability or                                     --
--  mechantability is implied or stated.                                     --
--                                                                           --
-------------------------------------------------------------------------------
use WORK.passpara.all;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
 
library COMPASS_LIB;
use COMPASS_LIB.COMPASS.ALL;

 
entity cell9 is

    port ( datain : in bit_vector(P downto 0);
           clk, bank : in bit;
	   sel, regen_bank1, regen_bank2 : in bit_vector (3 downto 0);
           coef : in bit_vector(P downto 0);
           acc : in bit_vector(M  downto 0);
           dataout : out bit_vector(M  downto 0) );
end cell9;
 
architecture behave OF cell9 is
 
signal REG1, REG1_bis, REG2, REG2_bis : bit_vector (P  downto 0);
signal REG3, REG3_bis, REG4, REG4_bis : bit_vector (P  downto 0);
signal sig1, sig2, sig3 : bit_vector (M downto 0);
 
begin
        process(clk)
 
-- declaring the variables:
--------------------------
      variable mul : bit_vector  (L downto 0);
      variable tmp1, tmp2, tmp3, tmp4, tmp5 : bit_vector (P downto 0);
      variable mul1 : bit_vector (M downto 0);
      variable tmp : bit_vector  (M downto 0);
 
        begin 
        if clk'event and clk = '1' then
		
		if regen_bank1(0)= '1' then
                    REG1 <= coef;
		end if;
		if regen_bank1(1)= '1' then
                    REG2 <= coef;
		end if;
		if regen_bank1(2)= '1' then
                    REG3 <= coef;
		end if;
		if regen_bank1(3)= '1' then
                    REG4 <= coef;
		end if;
-------------------------
		if regen_bank2(0)= '1' then
                    REG1_bis <= coef;
		end if;
		if regen_bank2(1)= '1' then
                    REG2_bis <= coef;
		end if;
		if regen_bank2(2)= '1' then
                    REG3_bis <= coef;
		end if;
		if regen_bank2(3)= '1' then
                    REG4_bis <= coef;
		end if;
-------------------------
                if bank = '1' then --  bank switch
		    tmp1 := REG1;
		    tmp2 := REG2;
		    tmp3 := REG3;
		    tmp4 := REG4;
		else
		    tmp1 := REG1_bis; 
		    tmp2 := REG2_bis;
		    tmp3 := REG3_bis; 
		    tmp4 := REG4_bis; 
		end if;

		if sel(0) = '1' then  --  sel for multiplexing switch
		   tmp := acc;
		   tmp5 := tmp1;   
		end if;
		if sel(1) = '1' then
		   tmp := sig3;
		   tmp5 := tmp2;   
		end if;
		if sel(2) = '1' then
		   tmp := sig3;
		   tmp5 := tmp3;   
		end if;
		if sel(3) = '1' then
		   tmp := sig3;
		   tmp5 := tmp4;   
		end if;
		mul := datain * tmp5;
		mul1 := sign_extend(mul,M+1);
		sig1 <= mul1 + tmp;
		sig2 <= sig1;
		sig3 <= sig2;
		if sel(0)= '1' then
                    dataout <= sig3;  -- output is passed on every  other cycle
		end if;
	end if;
        end process;
end behave;


