-------------------------------------------------------------------------------
--                                                     Copyright 1994        --
--                      (C)    Georgia Tech Research Corporation (GTRC).     --
--                                                   All rights reserved.    --
--                                                                           --
--  For non-commercial use                                                   --
--  provided that notice of this copyright is included at the beginning of   --
--  the software, the software may be copied, in its entirety without        --
--  alteration or as altered by (1) adding text that is clearly marked as an --
--  insertion; (2) shading or highlighting existing text; (3) deleting       --
--  examples.  This header must be preserved intact.                         --
--                                                                           --
--  Distribution authorized for non-commercial use to private individuals    --
--  or enterprises eligible                                                  --
--  to obtain export-controlled technical data in accordance with            --
--  regulations implementing 10 U.S.C. 1400 as of 31 March 1987.  Other      --
--  requests must be referred to the director, Advanced Research Projects    --
--  Agency.                                                                  --
--                                                                           --
--  This material may be reproduced by or for the U.S. Government pursuant   --
--  to the copyright license under the clause at DFARS 252.227-7013 (Oct 88) --
--                                                                           --
--  This work sponsored by US government under the following                 --
--  CONTRACT NUMBERS: Air Force - F33615-94C-1493                            --
--  RASSP Technology Base program, 1994-1997 to GTRC/DSP Laboratory,         --
--  Georgia Tech - Electrical and Computer Engineering (PI Dr. V. Madisetti) --
--  vkm@ee.gatech.edu, Fax: 404-853-9171.                                    --
--                                                                           --
--  For permission/license to include in a commercial product or for-profit  --
--  use in any form, please  contact,                                        --
--  Dr. Barry Rosenberg                 barry.rosenberg@gtrc.gatech.edu      --
--  Director - Office of Tech Licensing                                      --
--  Off Acad &  Res Support-GTRC 0415                                        --
--  Centennial Research Bldg                                                 --
--  Georgia Tech, Atlanta, GA 30332-0415,  404-894-6287                      --
--  No warranty as to its suitability or                                     --
--  mechantability is implied or stated.                                     --
--                                                                           --
-------------------------------------------------------------------------------
-------------------------------------------------------------------
-- Title:               FSM GENERATOR FOR A 2-Muxed PARALLEL FIR FILTER
-- Filename:            ctl_gen2.vhd  
-- Written by           M.S. Ben Romdhane
-------------------------------------------------------------------
----------------------FSM GENERATOR--------------------------------
-------PACKAGES

package DATATYPE2 is  
type STATE is (S0,S1,S2,S3a,S3b,S4a,S4b,S5);
end DATATYPE2;
------
------
--use WORK.fsmpara.all;
use WORK.passpara.all;
use WORK.DATATYPE2.all;

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library COMPASS_LIB;
use COMPASS_LIB.COMPASS.ALL;
use COMPASS_LIB.COMPASS_ARITH.ALL;
 
 
entity ctl_gen2 is
    port  (clk, reset, work, load, switch : in bit;
	   add : in integer range 0 to Q;
	   w_bank  : out bit;
	   sel : out bit;
	   add1, add2 : out bit_vector(Q downto 0)
);
end ctl_gen2;
   
architecture behavior of ctl_gen2 is

signal CURRENTSTATE  : STATE;
signal NEXTSTATE    : STATE;
 
begin


ctl_gen2_process: process(CURRENTSTATE,work,load,switch,add,sel)

begin

	case CURRENTSTATE is
	when S0 =>
		if load ='0' then
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S0;
		else
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				w_bank <= '1';
				sel <= '0';
			end if;
	           NEXTSTATE <= S1;
		end if;

	when S1 =>
		if load ='1' then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S1;
		else 
                       if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S2;
		end if;

	when S2 =>
		if (load ='0' and work ='0') then
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S2;
		elsif (load ='0' and work ='1') then
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				w_bank <= '1';
				sel <= '0';
			end if;		
		   NEXTSTATE <= S3a;
		elsif (load ='1' and work ='1') then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S4a;
		elsif (load ='1' and work ='0') then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S5;
		end if;
	
	when S3a =>
		if (load ='0' and work ='1') then 
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <='0';
				w_bank <='0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '1';
				sel <= '0';
			end if; 
		 NEXTSTATE <= S3b;
		elsif (load ='0' and work ='0') then
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S0;
		elsif (load ='1' and work ='1') then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '1';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '1';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '1';
				w_bank <= '1';
				sel <= '1';
			end if;
		   NEXTSTATE <= S4b;
		elsif (load ='1' and work ='0') then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '1';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '1';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S5;
		end if;
	when S3b =>
		if (load ='0' and work ='1') then 
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <='0';
				w_bank <='0';
				sel <= '1';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '1';
				sel <= '1';
			end if; 
		 NEXTSTATE <= S3a;
		elsif (load ='0' and work ='0') then
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S0;
		elsif (load ='1' and work ='1') then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '1';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '1';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S4a;
		elsif (load ='1' and work ='0') then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '1';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '1';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S5;
		end if;

	when S4a =>
		if (load ='1' and work ='1') then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '1';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '1';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S4b;
		elsif (load ='0' and work ='1') then
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '1';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '1';
				sel <= '1';
			end if;
		   NEXTSTATE <= S3b;
		elsif (load ='1' and work ='0') then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '1';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '1';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S5;
		elsif (load ='0' and work ='0') then
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S0;
		end if;
	when S4b =>
		if (load ='1' and work ='1') then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '1';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '1';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '1';
				w_bank <= '1';
				sel <= '1';
			end if;
		   NEXTSTATE <= S4a;
		elsif (load ='0' and work ='1') then
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S3a;
		elsif (load ='1' and work ='0') then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '1';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '1';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S5;
		elsif (load ='0' and work ='0') then
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S0;
		end if;

	when S5 =>
		if (load ='1' and work ='0') then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '1';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '1';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S5;
		elsif (load ='0' and work ='1') then   
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S3a;
		elsif (load ='1' and work ='1') then
			if switch = '0' then
				add1 <= itobv(2 ** add, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '1';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(2 ** add, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '1';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S4a;
		elsif (load ='0' and work ='0') then
			if switch = '0' then
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '0';
				sel <= '0';
			else
				add1 <= itobv(0, Q+1);
				add2 <= itobv(0, Q+1);
				--en_REG1 <= '0';
				--en_REG2 <= '0';
				w_bank <= '1';
				sel <= '0';
			end if;
		   NEXTSTATE <= S2;
		end if;
		
end case;

end process ctl_gen2_process;





ctl_gen2_seq : process(clk,reset)

begin
--compass stateMachine adj CURRENTSTATE
	if(To_X01(reset) = '0') then
		CURRENTSTATE <= S0;
	elsif (rising_edge(clk)) then

		CURRENTSTATE <= NEXTSTATE;

	end if;
end process ctl_gen2_seq;
end behavior;
