--------------------------------------------------------------------------------
--  Title:     Memory Model that uses mempkg to model a large memory.
--
--  Created:   Thu Apr 15 16:47:21 1999
--  Author:    Vijay A. Nebhrajani	<vijayn@sindhu>
--  Source File Name:   memory_model.vhd
--
--  $Id: memory_model.vhd,v 1.1 1999/04/15 16:47:21 vijayn Exp $
--
--  Description:   This model uses mempkg to model a 1Mx32 memory. This is a
--                 VHDL 93 file.
--
--  Revision History:   
--
--  $Log: memory_model.vhd,v $
--------------------------------------------------------------------------------

library IEEE, WORK;
use IEEE.std_logic_1164.all;
use WORK.mempkg.all;

entity memory1Mx32 is
  port     (address          : in     std_logic_vector(19 downto 0);
            data             : inout  std_logic_vector(31 downto 0);
            ce               : in     std_logic;
            oe               : in     std_logic;
            we               : in     std_logic
           );
end memory1Mx32;

architecture memory1Mx32_A of memory1Mx32 is

  shared variable my_memory : vmem_ptr := create_mem(20, 32);
  signal data_s           : std_logic_vector(31 downto 0);
  
begin

  mem_write_P : process(ce, we)
    
  begin
    --  CE terminated write
    if (ce'event and ce = '1') then
      if (we = '0') then
        write_mem(my_memory, address, data);
      end if;
    end if;

    --  WE terminated write
    if (we'event and we = '1') then
      if (ce = '0') then
        write_mem(my_memory, address, data);
      end if;
    end if;
    
  end process;
  
  mem_read_P : process(address, oe, ce)
  
  begin
    if (address'event or 
       (oe'event and oe = '0') or
       (ce'event and ce = '0')
       ) then
      read_mem(my_memory, address, data_s);
    end if;

  end process;
  
  --  OE tristates the output.
  --  If you need to model an output delay, you can do something
  --  like 
  --        data <= transport data_s after 30 ns;
  
  data <= data_s when (oe = '0' and ce = '0') else (others => 'Z');

  --  You can add more processes to do setup/hold checks.

end memory1Mx32_A;
