library IEEE, STD, WORK;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use WORK.mempkg.all;
use IEEE.std_logic_textio.all;
use STD.textio.all;

entity memory1Mx32_tst is
end memory1Mx32_tst;

architecture  memory1Mx32_tst_A of memory1Mx32_tst is 

  component memory1Mx32
    port     (address                  : in         std_logic_vector(19 downto 0);
              data                     : inout      std_logic_vector(31 downto 0);
              ce                       : in         std_logic;
              oe                       : in         std_logic;
              we                       : in         std_logic
             );
  end component;

  signal    address_s                :  std_logic_vector(19 downto 0);
  signal    data_s                   :  std_logic_vector(31 downto 0);
  signal    ce_s                     :  std_logic;
  signal    oe_s                     :  std_logic;
  signal    we_s                     :  std_logic;

  file vector_file : text is in  "memory_model.vec";
  file list_file   : text is out "memory_model.list";

begin

  u1 : memory1Mx32
    port map    (address                   =>  address_s,
                 data                      =>  data_s,
                 ce                        =>  ce_s,
                 oe                        =>  oe_s,
                 we                        =>  we_s
                );

  test_P : process

    variable inp_line                 :  line;
    variable op_line                  :  line;
    variable current_time             :  time;
    variable wait_period              :  time;
    variable address_v                :  std_logic_vector(19 downto 0);
    variable data_v                   :  std_logic_vector(31 downto 0);
    variable ce_v                     :  std_logic;
    variable oe_v                     :  std_logic;
    variable we_v                     :  std_logic;

  begin
      if endfile(vector_file) then
        assert false
        report "End of vectors file."
        severity note;
        wait;
      else
        readline(vector_file, inp_line);
        read(inp_line, address_v);
        read(inp_line, data_v);
        read(inp_line, ce_v);
        read(inp_line, oe_v);
        read(inp_line, we_v);
        read(inp_line, wait_period);
      end if;

      address_s                  <= address_v;
      data_s                     <= data_v;
      ce_s                       <= ce_v;
      oe_s                       <= oe_v;
      we_s                       <= we_v;

      data_v                     := data_s;
      current_time               := now;

      write(op_line, current_time, right, 10);
      write(op_line, address_v, right, 24);
      write(op_line, data_v, right, 36);
      write(op_line, ce_v, right, 4);
      write(op_line, oe_v, right, 4);
      write(op_line, we_v, right, 4);
      writeline(list_file, op_line);

      wait for wait_period;

  end process;

end memory1Mx32_tst_A;

configuration memory1Mx32_tst_C of memory1Mx32_tst is
  for memory1Mx32_tst_A
    for u1 : memory1Mx32 use entity work.memory1Mx32(memory1Mx32_A);
    end for;
  end for;
end memory1Mx32_tst_C;
