library IEEE;
use IEEE.std_logic_1164.all;

entity iec_c30_interface is
  port ( RESET           : in std_logic;
         H3_CLK          : in std_logic;
         PH_DATA_I       : in std_logic_vector(31 downto 0);
         PH_ADDR         : in std_logic_vector(3 downto 0);
         PH_RW           : in std_logic;
         IEC_RX_SEL      : in std_logic;
         B_FLAG          : in std_logic;
         LEFT_RIGHT      : in std_logic;
         NEW_DATA_FLAG   : in std_logic;
         DATA_IN         : in std_logic_vector(27 downto 0);

         IEC_RESET       : out std_logic;
         MODE            : out std_logic_vector(1 downto 0);
         CLKSRC          : out std_logic_vector(1 downto 0);
         IEC_RX_INT      : out std_logic;
         INT_CLK         : out std_logic;
         PH_DATA_O       : out std_logic_vector(31 downto 0));
end iec_c30_interface;

architecture beh of iec_c30_interface is

  component iec_c30_reg
  port ( RESET             : in std_logic;
         H3_CLK            : in std_logic;
         GLO_CONT_SEL      : in std_logic;
         TIMER_CONT_SEL    : in std_logic;
         TIMER_PERIOD_SEL  : in std_logic;
         DATA_RX_SEL       : in std_logic;
         PH_RW             : in std_logic;
         PH_DATA_I         : in std_logic_vector(31 downto 0);
         B_FLAG            : in std_logic;
         LEFT_RIGHT        : in std_logic;
         DATA_W_EN         : in std_logic;
         DATA_IN           : in std_logic_vector(27 downto 0);
 
         IEC_RESET         : out std_logic;
         MODE              : out std_logic_vector(1 downto 0);
         CLKSRC            : out std_logic_vector(1 downto 0);
         INT_EN            : out std_logic;
         INT_CLK           : out std_logic;
         PH_DATA_O         : out std_logic_vector(31 downto 0));
  end component;

  signal glo_cont_sel  : std_logic;
  signal timer_cont_sel, timer_period_sel  : std_logic;
  signal data_rx_sel  : std_logic;
  signal data_w_en  : std_logic;
  signal int_en  : std_logic;

  signal flag_buf0, flag_buf1  : std_logic;

begin

  glo_cont_sel <= '1' when (IEC_RX_SEL = '1' and PH_ADDR = "0000") else '0';      -- 8080A0h
  timer_cont_sel <= '1' when (IEC_RX_SEL = '1' and PH_ADDR = "0100") else '0';    -- 8080A4h
  timer_period_sel <= '1' when (IEC_RX_SEL = '1' and PH_ADDR = "0101") else '0';  -- 8080A5h
  data_rx_sel <= '1' when (IEC_RX_SEL = '1' and PH_ADDR = "1000") else '0';       -- 8080A8h

  i_iec_c30_reg: iec_c30_reg port map
    ( RESET => RESET,
      H3_CLK => H3_CLK,
      GLO_CONT_SEL => glo_cont_sel,
      TIMER_CONT_SEL => timer_cont_sel,
      TIMER_PERIOD_SEL => timer_period_sel,
      DATA_RX_SEL => data_rx_sel,
      PH_RW => PH_RW,
      PH_DATA_I => PH_DATA_I,
      B_FLAG => B_FLAG,
      LEFT_RIGHT => LEFT_RIGHT,
      DATA_W_EN => data_w_en,
      DATA_IN => DATA_IN,
 
      IEC_RESET => IEC_RESET,
      MODE => MODE,
      CLKSRC => CLKSRC,
      INT_EN => int_en,
      INT_CLK => INT_CLK,
      PH_DATA_O => PH_DATA_O);

  flag_buf: process (RESET, H3_CLK)
  begin
    if (RESET = '0') then
      flag_buf0 <= '0';
      flag_buf1 <= '0';
    elsif (H3_CLK'event and H3_CLK = '1') then
      flag_buf0 <= NEW_DATA_FLAG;
      flag_buf1 <= flag_buf0;
    end if;
  end process flag_buf;

  -- Single pulse gen.
  data_w_en <= '1' when (flag_buf0 = '1' and flag_buf1 = '0') else '0';

  int_flag: process (RESET, H3_CLK)
  begin
    if (RESET = '0') then
      IEC_RX_INT <= '0';
    elsif (H3_CLK'event and H3_CLK = '1') then
      if (int_en = '1') then
        IEC_RX_INT <= data_w_en;
      else
        IEC_RX_INT <= '0';
      end if;
    end if;
  end process int_flag;

end beh;
