library IEEE;
use IEEE.std_logic_1164.all;

entity iec_data_reg is
  port ( RESET           : in std_logic;
         CLK             : in std_logic;
         DATA_BIT_READY  : in std_logic;
         DATA_BIT        : in std_logic;
         B_FLAG          : in std_logic;
         LEFT_RIGHT      : in std_logic;
         DATA_LOAD       : in std_logic;
         DATA_OUT        : out std_logic_vector(27 downto 0);
         B_FLAG_OUT      : out std_logic;
         LEFT_RIGHT_OUT  : out std_logic;
         NEW_DATA_FLAG   : out std_logic);
end iec_data_reg;

architecture beh of iec_data_reg is

  signal shift_val  : std_logic_vector(0 to 27);
  signal data  : std_logic_vector(27 downto 0);

begin

  shift_val_pro: process (RESET, CLK)
  begin
    if (RESET = '0') then
      shift_val <= (others => '0');
    elsif (CLK'event and CLK = '1') then
      if (DATA_BIT_READY = '1') then
        shift_val(0 to 26) <= shift_val(1 to 27);
        shift_val(27) <= DATA_BIT;
      end if;
    end if;
  end process shift_val_pro;

  data_pro: process (RESET, CLK)
  begin
    if (RESET = '0') then
      data <= (others => '0');
      B_FLAG_OUT <= '0';
      LEFT_RIGHT_OUT <= '1';
    elsif (CLK'event and CLK = '1') then
      if (DATA_LOAD = '1') then

        for i in 0 to 27 loop
          data(i) <= shift_val(i);
        end loop;

        LEFT_RIGHT_OUT <= LEFT_RIGHT;
        B_FLAG_OUT <= B_FLAG;

      end if;
    end if;
  end process data_pro; 

  -- Single pulse gen.
  new_data_flag_pro: process (RESET, CLK)
  begin
    if (RESET = '0') then
      NEW_DATA_FLAG <= '0';
    elsif (CLK'event and CLK = '1') then
      if (DATA_LOAD = '1') then
        NEW_DATA_FLAG <= '1';
      else
        NEW_DATA_FLAG <= '0';
      end if;
    end if;
  end process new_data_flag_pro;

  DATA_OUT <= data;
  
end beh;
