library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity iec_sync_det is
  port ( RESET           : in std_logic;
         CLK             : in std_logic;
         IECIN           : in std_logic;
         MODE            : in std_logic_vector(1 downto 0);
         B_FLAG          : out std_logic;
         LEFT_RIGHT      : out std_logic;
         DATA_BIT_READY  : out std_logic;
         DATA_BIT        : out std_logic;
         DATA_LOAD       : out std_logic);
end iec_sync_det;

architecture beh of iec_sync_det is

  component iec_common_block
  port ( RESET           : in std_logic;
         CLK             : in std_logic;
         IECIN           : in std_logic;
         B_PREAMBLE      : in std_logic;
         M_PREAMBLE      : in std_logic;
         W_PREAMBLE      : in std_logic;
         CNT_CLR         : in std_logic;
         DATA_BIT_READY  : in std_logic;
         SHIFT_VAL_OUT   : out std_logic_vector(0 to 32);
         CNT_OUT         : out std_logic_vector(3 downto 0);
         B_FLAG          : out std_logic;
         LEFT_RIGHT      : out std_logic;
         DATA_LOAD       : out std_logic);
  end component;

  component iec_fs_44k_block
  port ( SHIFT_VAL       : in std_logic_vector(0 to 22);
         CNT             : in std_logic_vector(3 downto 0);
         DATA_BIT_READY  : out std_logic;
         DATA_BIT        : out std_logic;
         B_PREAMBLE      : out std_logic;
         M_PREAMBLE      : out std_logic;
         W_PREAMBLE      : out std_logic;
         CNT_CLR         : out std_logic);
  end component;

  component iec_fs_32k_block
  port ( SHIFT_VAL       : in std_logic_vector(0 to 32);
         CNT             : in std_logic_vector(3 downto 0);
         DATA_BIT_READY  : out std_logic;
         DATA_BIT        : out std_logic;
         B_PREAMBLE      : out std_logic;
         M_PREAMBLE      : out std_logic;
         W_PREAMBLE      : out std_logic;
         CNT_CLR         : out std_logic);
  end component;

  component iec_fs_48k_block
  port ( SHIFT_VAL       : in std_logic_vector(0 to 20);
         CNT             : in std_logic_vector(3 downto 0);
         DATA_BIT_READY  : out std_logic;
         DATA_BIT        : out std_logic;
         B_PREAMBLE      : out std_logic;
         M_PREAMBLE      : out std_logic;
         W_PREAMBLE      : out std_logic;
         CNT_CLR         : out std_logic);
  end component;

  signal shift_val  : std_logic_vector(0 to 32);
  signal cnt  : std_logic_vector(3 downto 0);
  signal b_preamble, m_preamble, w_preamble  : std_logic;
  signal cnt_clr  : std_logic;
  signal data_bit_ready_tmp  : std_logic;

  signal data_bit_ready_44k, data_bit_44k  : std_logic;
  signal b_preamble_44k, m_preamble_44k, w_preamble_44k  : std_logic;
  signal cnt_clr_44k  : std_logic;
  signal data_bit_ready_32k, data_bit_32k  : std_logic;
  signal b_preamble_32k, m_preamble_32k, w_preamble_32k  : std_logic;
  signal cnt_clr_32k  : std_logic;
  signal data_bit_ready_48k, data_bit_48k  : std_logic;
  signal b_preamble_48k, m_preamble_48k, w_preamble_48k  : std_logic;
  signal cnt_clr_48k  : std_logic;

begin

  i_iec_common_block: iec_common_block port map
   ( RESET => RESET,
     CLK => CLK,
     IECIN => IECIN,
     B_PREAMBLE => b_preamble,
     M_PREAMBLE => m_preamble,
     W_PREAMBLE => w_preamble,
     CNT_CLR => cnt_clr,
     DATA_BIT_READY => data_bit_ready_tmp,
     SHIFT_VAL_OUT => shift_val,
     CNT_OUT => cnt,
     B_FLAG => B_FLAG,
     LEFT_RIGHT => LEFT_RIGHT,
     DATA_LOAD => DATA_LOAD);

  i_iec_fs_44k_block: iec_fs_44k_block port map
   ( SHIFT_VAL => shift_val(10 to 32),
     CNT => cnt,
     DATA_BIT_READY => data_bit_ready_44k,
     DATA_BIT => data_bit_44k,
     B_PREAMBLE => b_preamble_44k,
     M_PREAMBLE => m_preamble_44k,
     W_PREAMBLE => w_preamble_44k,
     CNT_CLR => cnt_clr_44k);

  i_iec_fs_32k_block: iec_fs_32k_block port map
   ( SHIFT_VAL => shift_val,
     CNT => cnt,
     DATA_BIT_READY => data_bit_ready_32k,
     DATA_BIT => data_bit_32k,
     B_PREAMBLE => b_preamble_32k,
     M_PREAMBLE => m_preamble_32k,
     W_PREAMBLE => w_preamble_32k,
     CNT_CLR => cnt_clr_32k);

  i_iec_fs_48k_block: iec_fs_48k_block port map
   ( SHIFT_VAL => shift_val(12 to 32),
     CNT => cnt,
     DATA_BIT_READY => data_bit_ready_48k,
     DATA_BIT => data_bit_48k,
     B_PREAMBLE => b_preamble_48k,
     M_PREAMBLE => m_preamble_48k,
     W_PREAMBLE => w_preamble_48k,
     CNT_CLR => cnt_clr_48k);

  mode_sel: process (MODE,
                     data_bit_ready_44k, data_bit_44k, 
                     b_preamble_44k, m_preamble_44k, w_preamble_44k,
                     cnt_clr_44k,
                     data_bit_ready_32k, data_bit_32k, 
                     b_preamble_32k, m_preamble_32k, w_preamble_32k,
                     cnt_clr_32k,
                     data_bit_ready_48k, data_bit_48k, 
                     b_preamble_48k, m_preamble_48k, w_preamble_48k,
                     cnt_clr_48k)
  begin

    if (MODE = "01") then
      data_bit_ready_tmp <= data_bit_ready_32k;
      DATA_BIT <= data_bit_32k;
      b_preamble <= b_preamble_32k;
      m_preamble <= m_preamble_32k;
      w_preamble <= w_preamble_32k;
      cnt_clr <= cnt_clr_32k;
    elsif (MODE = "10") then
      data_bit_ready_tmp <= data_bit_ready_48k;
      DATA_BIT <= data_bit_48k;
      b_preamble <= b_preamble_48k;
      m_preamble <= m_preamble_48k;
      w_preamble <= w_preamble_48k;
      cnt_clr <= cnt_clr_48k;
    else
      data_bit_ready_tmp <= data_bit_ready_44k;
      DATA_BIT <= data_bit_44k;
      b_preamble <= b_preamble_44k;
      m_preamble <= m_preamble_44k;
      w_preamble <= w_preamble_44k;
      cnt_clr <= cnt_clr_44k;
    end if;

  end process mode_sel;

  DATA_BIT_READY <= data_bit_ready_tmp;
  
end beh;
