use STD.TEXTIO.all;
use work.COMPUTE_PACK.all;
use work.IO_PACK.all;
use work.INTERFACE_PACK.all;

entity DAC is
end DAC;

architecture DAC of DAC is

   component anavhdl
      port (v_output     : out VALUE_ARRAY;    -- Analog output.
            T_IN         : out TIME;      -- Circuit simulation Time.
            stop         : out TIME;      -- Simulation end time.
            incri        : out TIME;    -- Time incriment step.
            Vgs          : out real;
            extern_feed  : in boolean;
            FILE_FLAG    : in boolean;
            lowpass_feed  : in boolean;
            lowpass_input  : in VALUE_ARRAY;
            error_value  : in VALUE_ARRAY;
	    DC_IN        : in VALUE_ARRAY;
	    DC_FLAG      : in boolean);
   end component;


for all : anavhdl use entity work.anavhdl(anavhdl);

    signal v_output1     : VALUE_ARRAY(1 to 100);
    signal v_output2     : VALUE_ARRAY(1 to 100);
    signal T_IN1         : TIME;
    signal T_IN2         : TIME;
    signal stop_at1      : TIME;
    signal stop_at2      : TIME;
    signal LOGIC_OUTPUT : SWITCH_LEVEL;
    signal clock        : SWITCH_LEVEL;
    signal dff_out      : SWITCH_LEVEL;
    signal stop_sim     : boolean := false;
    signal anaout       : real;
    signal extern_feed1  : boolean := false;
    signal extern_feed2  : boolean := false;
    signal error_value  : VALUE_ARRAY (1 to 100);
    signal Vgs1          : real;
    signal Vgs2          : real;
    signal sigdel_real_out : VALUE_ARRAY (1 to 100);
    signal lowpass_feed1 : boolean := false;
    signal lowpass_feed2 : boolean := false;
    signal lowpass_input1  : VALUE_ARRAY (1 to 100);
    signal lowpass_input2  : VALUE_ARRAY (1 to 100);
    signal lowpass_out : real;
    signal FILE_FLAG1 : BOOLEAN := TRUE;
    signal FILE_FLAG2 : BOOLEAN := FALSE;
    signal DC_IN1     : VALUE_ARRAY(1 to 100);
    signal DC_IN2     : VALUE_ARRAY(1 to 100);
    signal DC_FLAG1   : boolean := FALSE;
    signal DC_FLAG2   : boolean := TRUE;

file FILE2 : TEXT is out "STD_OUTPUT";

begin

   ana1 : anavhdl
		port map (v_output => v_output1, T_IN => T_IN1,
                          stop => stop_at1, extern_feed => extern_feed1, 
                          error_value => error_value, Vgs => Vgs1,
                          lowpass_feed => lowpass_feed1,
                          lowpass_input => lowpass_input1,
                          FILE_FLAG => FILE_FLAG1, DC_IN => DC_IN1,
			  DC_FLAG => DC_FLAG1);
                          
   ana2 : anavhdl
		port map (v_output => v_output2, T_IN => T_IN2,
                          stop => stop_at2,
                          extern_feed => extern_feed2,
                          error_value => error_value, Vgs => Vgs2,
                          lowpass_feed => lowpass_feed2,
                          lowpass_input => lowpass_input2,
                          FILE_FLAG => FILE_FLAG2, DC_IN => DC_IN2,
			  DC_FLAG => DC_FLAG2);
			 


     
stop_control : process

 begin

   wait until stop_sim = true;
   assert false report "Stopping simulation"severity failure;

end process stop_control;


p1 : process
   
     variable K : LINE;
     variable i : positive;

  begin


        lowpass_feed1 <= false;
        lowpass_feed2 <= false;
        write(K, "Vdc(1) = ");
	write(K,v_output1(1));
	write(K, "  ");
	DC_IN2 <= v_output1;
 	write(K, "opamp_out = ");
	write(K,v_output2(2));
	writeline(OUTPUT,K);	
	wait;
	stop_sim <= true;

end process p1;

end DAC;
