-- ****************************************************************************
-- *                                                                          *
-- *  THIS IS THE TOP MODULE IN WHICH THE TWO EXAMPLE ANALOG CIRCUITS IS      *
-- *  CONNECTED TO A NAND GATE WITH THE INTERFACE MODULE INBETWEEN THE        *
-- *  ANALOG AND DIGITAL PART.                                                *
-- *                                                                          *
-- ****************************************************************************

use work.COMPUTE_PACK.all;
use work.IO_PACK.all;
use work.INTERFACE_PACK.all;
use STD.TEXTIO.all;

entity system is
end system;

architecture system of system is

   component anavhdl
      port (v_output     : out VALUE_ARRAY;    -- Analog output.
            T_IN         : out TIME;      -- Circuit simulation Time.
            stop         : out TIME;      -- Simulation end time.
            incri        : out TIME;    -- Time incriment step.
            Vgs          : out real;
            extern_feed  : in boolean;
            FILE_FLAG    : in boolean;
	    lowpass_feed : in boolean;
	    lowpass_input : in VALUE_ARRAY;
            error_value  : in VALUE_ARRAY);
   end component;

   component A2D
      generic (hi_cutoff : real;        
               lo_cutoff : real);
      port (LOGIC_OUTPUT : out SWITCH_LEVEL;  -- Digital voltage output.
            ANALOG_INPUT : in real;           -- Analog voltage output.
            T_input      : in TIME;           -- Circuit simulation time.
            stop_at      : in TIME;           -- Simulation end time.
            Vgate_src    : in real);
   end component;

   component D2A
      port (LOGIC_IN      : in SWITCH_LEVEL;  -- Digital voltage input.
            Time_in       : in TIME;          -- Simulation time from AnaVHDL.
            stop_after    : in TIME;          -- Simulation end time.
            ANALOG_OUTPUT : out real);        -- Analog voltage output.
   end component;

   component nand_gate
      generic(width : integer; delay_time : time);
      port (input : in SWITCH_LEVEL_VECTOR((width-1) downto 0);        
            output : out SWITCH_LEVEL);
   end component;
 
for all : anavhdl use entity work.anavhdl(anavhdl);
for all : A2D use entity work.A2D(A2D);
for all : D2A use entity work.D2A(D2A);
for all : nand_gate use entity work.nand_gate(simple_nand);

   signal input1        :  VALUE_ARRAY(1 to 100);  -- Signal feeding the A2D 
                                                   -- entity from AnaVHDL.
   signal input2        :  VALUE_ARRAY(1 to 100);  --    same as above
   signal in1           :  SWITCH_LEVEL; -- Signal feeding Nand entity from A2D.
   signal in2           :  SWITCH_LEVEL; --    same as above.
   signal out1          :  SWITCH_LEVEL; -- Signal feeding Nand o/p to D2A.
   signal stop_after1   :  TIME;  -- Signal passing the simulation stop_time.
   signal stop_after2   :  TIME;  --    same as above.
   signal incriment1    :  TIME := 0 ns; -- Time incriment for simulation step.
   signal incriment2    :  TIME := 0 ns; --   same as above.
   signal analog        :  real:= 0.0;         -- Analog o/p from D2A entity.
   signal t1            :  TIME;     -- Passing Time values to all the entities.
   signal t2            :  TIME;
   signal v_gate_src1   :  real;
   signal v_gate_src2   :  real;
   signal extern_feed1  :  boolean;
   signal error_value1  :  VALUE_ARRAY(1 to 100);
   signal extern_feed2  :  boolean;
   signal error_value2  :  VALUE_ARRAY(1 to 100);
   signal FILE_FLAG1    :  boolean := TRUE;
   signal FILE_FLAG2    :  boolean := FALSE;
   signal lowpass_feed1 :  boolean;
   signal lowpass_feed2 :  boolean;
   signal lowpass_input1:  VALUE_ARRAY(1 to 100);
   signal lowpass_input2:  VALUE_ARRAY(1 to 100);
   signal stop_sim:  boolean := false;


file FILE2 : TEXT is out "STD_OUTPUT";

begin

   ana1 : anavhdl
               port map (v_output => input1, stop => stop_after1,
                         incri => incriment1, T_IN => t1, Vgs => v_gate_src1,
                         extern_feed => extern_feed1, FILE_FLAG => FILE_FLAG1,
			 lowpass_feed => lowpass_feed1, lowpass_input =>
			 lowpass_input1, error_value => error_value1);

   ana2 : anavhdl
               port map (v_output => input2, stop => stop_after2,
                         incri => incriment2, T_IN => t2, Vgs => v_gate_src2,
                         extern_feed => extern_feed1, FILE_FLAG => FILE_FLAG2,
			 lowpass_feed => lowpass_feed2, lowpass_input =>
			 lowpass_input2,error_value => error_value2); 

   a2d1 : A2D
            generic map (hi_cutoff => 3.7, lo_cutoff => 1.7) 
            port map (ANALOG_INPUT => input1(2), LOGIC_OUTPUT => in1, 
                      T_input => t1, stop_at => stop_after1, 
                      Vgate_src => v_gate_src1);

   a2d2 : A2D 
            generic map (hi_cutoff => 3.7, lo_cutoff => 1.7)
            port map (ANALOG_INPUT => input2(2), LOGIC_OUTPUT => in2,
                      T_input => t2, stop_at => stop_after2,
                      Vgate_src => v_gate_src2);

   nand1: nand_gate 
               generic map(2,0 ns)
               port map(input(1) => in1, input(0) => in2,
                             output => out1);

   d2a1 : D2A 
            port map (LOGIC_IN => out1, Time_in => t1,
                      stop_after => stop_after1, ANALOG_OUTPUT => analog);

  stop : process

      begin
         wait until stop_sim = true;
         assert false report "Stopping Simulation" severity failure;

 end process stop;


  p1 : process
      
      variable  K   :  LINE;             -- Debugg variable.
      
     begin

          
       if (t1 < (stop_after1 - 1 ns)) then
          wait for 0 ns;
          write(K,t1);
          write(K,"  ");
          wait for 0 ns;
          write(K,analog);
          writeline(OUTPUT,K);
       end if;
       wait for 5 ns;
       if t1 = 500 ns then
         stop_sim <= true;
       end if;
  end process p1;

end system;
