use work.INTERFACE_PACK.all;

entity nand_gate is
generic (width : integer;
	 delay_time : time); 
port (input : in SWITCH_LEVEL_VECTOR ((width - 1) downto 0);
      output : out SWITCH_LEVEL );
end nand_gate;

architecture simple_nand of nand_gate is
begin
p : process
     variable temp : SWITCH_LEVEL;
     begin
      temp := '0';  
      repeat :
       for i in 0 to (width - 1) loop
	if input(i) = 'X' then
	 temp := 'X';
	elsif input(i) = '0' then
	 temp := '1';
        end if;
      end loop repeat;
      output <= transport temp after delay_time;
      wait on input;
end process;

end simple_nand;
