use STD.TEXTIO.all;
use work.COMPUTE_PACK.all;
use work.IO_PACK.all;
use work.INTERFACE_PACK.all;

entity sigdel is
end sigdel;

architecture sigdel of sigdel is

   component anavhdl
      port (v_output     : out VALUE_ARRAY;    -- Analog output.
            T_IN         : out TIME;      -- Circuit simulation Time.
            stop         : out TIME;      -- Simulation end time.
            incri        : out TIME;    -- Time incriment step.
            Vgs          : out real;
            extern_feed  : in boolean;
            FILE_FLAG    : in boolean;
            lowpass_feed  : in boolean;
            lowpass_input  : in VALUE_ARRAY;
            error_value  : in VALUE_ARRAY);
   end component;

   component A2D
      generic (hi_cutoff : real;
               lo_cutoff : real);
      port (LOGIC_OUTPUT : out SWITCH_LEVEL;  -- Digital voltage output.
            ANALOG_INPUT : in real;           -- Analog voltage output.
            T_input      : in TIME;           -- Circuit simulation time.
            stop_at      : in TIME;           -- Simulation end time.
            Vgate_src    : in real);
   end component;

   component D2A
      port (LOGIC_IN      : in SWITCH_LEVEL;  -- Digital voltage input.
            Time_in       : in TIME;          -- Simulation time from AnaVHDL.
            stop_after    : in TIME;          -- Simulation end time.
            ANALOG_OUTPUT : out real);        -- Analog voltage output.
   end component;

   component d_ff
      generic (nand_delay : time := 0 ns);
      port(clock, data : in SWITCH_LEVEL;
           q, qb : out SWITCH_LEVEL);
   end component;


for all : anavhdl use entity work.anavhdl(anavhdl);
for all : A2D use entity work.A2D(A2D);
for all : D2A use entity work.D2A(D2A);
for all : d_ff use entity work.d_ff(d_ff);

    signal v_output1     : VALUE_ARRAY(1 to 100);
    signal v_output2     : VALUE_ARRAY(1 to 100);
    signal T_IN1         : TIME;
    signal T_IN2         : TIME;
    signal stop_at1      : TIME;
    signal stop_at2      : TIME;
    signal LOGIC_OUTPUT : SWITCH_LEVEL;
    signal clock        : SWITCH_LEVEL;
    signal dff_out      : SWITCH_LEVEL;
    signal stop_sim     : boolean := false;
    signal anaout       : real;
    signal extern_feed1  : boolean := false;
    signal extern_feed2  : boolean := false;
    signal error_value  : VALUE_ARRAY (1 to 100);
    signal Vgs1          : real;
    signal Vgs2          : real;
    signal sigdel_real_out : VALUE_ARRAY (1 to 100);
    signal lowpass_feed1 : boolean := false;
    signal lowpass_feed2 : boolean := false;
    signal lowpass_input1  : VALUE_ARRAY (1 to 100);
    signal lowpass_input2  : VALUE_ARRAY (1 to 100);
    signal lowpass_out : real;
    signal FILE_FLAG1 : BOOLEAN := TRUE;
    signal FILE_FLAG2 : BOOLEAN := FALSE;


file FILE2 : TEXT is out "STD_OUTPUT";

begin

   ana1 : anavhdl
		port map (v_output => v_output1, T_IN => T_IN1,
                          stop => stop_at1, extern_feed => extern_feed1, 
                          error_value => error_value, Vgs => Vgs1,
                          lowpass_feed => lowpass_feed1,
                          lowpass_input => lowpass_input1,
                          FILE_FLAG => FILE_FLAG1);
                          
   ana2 : anavhdl
		port map (v_output => v_output2, T_IN => T_IN2,
                          stop => stop_at2,
                          extern_feed => extern_feed2,
                          error_value => error_value, Vgs => Vgs2,
                          lowpass_feed => lowpass_feed2,
                          lowpass_input => lowpass_input2,
                          FILE_FLAG => FILE_FLAG2);
			 
   a2d1 : A2D
		generic map (hi_cutoff => 3.7, lo_cutoff => 1.7)
		port map (LOGIC_OUTPUT => LOGIC_OUTPUT, ANALOG_INPUT 
            	        => v_output1(8),T_input => T_IN1, stop_at => stop_at1,
                           Vgate_src => Vgs1);

   d_ff1 : d_ff
                generic map (1 ns)
		port map (data => LOGIC_OUTPUT, clock => clock, q => dff_out);

   d2a1 : D2A
		port map (LOGIC_IN => dff_out, Time_in => T_IN2, stop_after =>
			  stop_at2, ANALOG_OUTPUT => anaout);


     
stop_control : process

  begin

     wait until stop_sim = true;
     assert false report "Stopping simulation"severity failure;

end process stop_control;


p1 : process
   
     variable K : LINE;
     variable t : time := 0 ns;
     variable i : integer := 1;
     variable j : integer := 1;
     variable l : integer := 1;

  begin

      loop1:
        for i in 1 to 100 loop
         write(K,"Time = ");
         write(K,T_IN1);
         write(K," ");
         clock <= '0', '1' after 2 ns, '0' after 3 ns;
         wait for 5 ns;
         if t < 195 ns then
            error_value(i) <= error1(anaout);
         elsif t > 195 ns then
            extern_feed1 <= true;
            error_value <= error_value;
            sigdel_real_out(l) <= anaout;
            j := j + 1;
            l := l + 1;
            lowpass_feed2 <= true;
            lowpass_input2 <= sigdel_real_out;
            lowpass_out <= v_output2(2);
         end if;
         write(K,"anaout = ");
         wait for 0 ns;
         write(K,anaout);
         writeline(OUTPUT,K);
         t := t + 5 ns;
         exit loop1 when t = 300 ns;
      end loop loop1;
      stop_sim <= true;

end process p1;

end sigdel;
