-- ****************************************************************************
-- *                                                                          *
-- *    THIS MODULE PERFORMS ANALOG TO DIGITAL CONVERSION USING FUNCTIONS     *
-- *                 IN THE PACKAGE "INTERFACE_PACK.vhdl"                     *
-- *                                                                          *
-- ****************************************************************************

use work.COMPUTE_PACK.all;
use work.IO_PACK.all;
use work.INTERFACE_PACK.all;
use STD.TEXTIO.all;

entity A2D is
   generic (hi_cutoff : real;
            lo_cutoff : real);
   port (LOGIC_OUTPUT : out SWITCH_LEVEL;   -- Digital voltage output.
         ANALOG_INPUT : in real;            -- Analog voltage input.
         T_input      : in TIME;            -- circuit simulation time.
         stop_at      : in TIME;            -- Simulation end time.
         Vgate_src    : in real);
end A2D;

architecture A2D of A2D is

  signal volt_out    : real;
  signal LOGIC_OUT   : SWITCH_LEVEL;
  signal current_in1 : real;
  signal t           : TIME;
  signal temp        : TIME := 0 ns;


file FILE2 :TEXT is out "STD_OUTPUT";



begin

  p1  : process

      variable i  : integer := 1;
      variable d1 : time := 0 ns;
      variable d2 : time := 0 ns;
      variable K  : LINE;

      begin
        
         if ANALOG_INPUT <= hi_cutoff then
            d1 := t;
            wait until (ANALOG_INPUT <= lo_cutoff);
            d2 := t;
         end if;
         temp <= abs(d1 - d2);
         wait for 1 ns;

  end process p1;


  p2  : process

      constant Ref_time          : TIME := 1 ns; -- Constant Reference time.
      variable actual_delta      : real := 0.0;  -- time lapse between lo and 
      variable lo_cut_time       : real := 0.0;  --          hi cutoff points.
      variable hi_cut_time       : real := 0.0;		
      variable Ref_time_real     : real;	
      variable t_real            : real;
      variable i                 : integer := 1;
      variable K                 : LINE;          -- debugg variable.


     begin

         t <= T_input;         -- Time value is assigned from port to signal.
         volt_out <= ANALOG_INPUT;        
         t_real := TIME_TO_REAL(t);    -- time to real conversion of time 't'.
         Ref_time_real:= TIME_TO_REAL(Ref_time); 
         actual_delta := TIME_TO_REAL(temp);

-- when the actual_delta is greater than Ref_time then the inertial delay is
-- used to assign the logic value to the port.

         if Vgate_src < 0.8 then
            LOGIC_OUTPUT <= 'Z';
         else
          if t >= 0 ns then
           if actual_delta > Ref_time_real then
             wait for 0 ns;
             LOGIC_OUTPUT <= threshold(ANALOG_INPUT) after Ref_time ;

-- when the actual_delta is less than the Ref_time the logic value is assigned 
-- to the port immediately with either '0' or '1'.

           elsif actual_delta < Ref_time_real then
             wait for 0 ns;
             LOGIC_OUTPUT <= threshold_1(ANALOG_INPUT);

-- when the actual_delta is equal to the Ref_time then logic value is assigned 
-- to the port immediately with values '0', '1', or 'X'.

           elsif actual_delta = Ref_time_real then
             LOGIC_OUTPUT <= threshold(ANALOG_INPUT);
             wait for 0 ns;
           else
             LOGIC_OUTPUT <= high_imped(current_in1);
           end if;
          end if;
         end if;
         wait for 1 ns;
  end process p2;

end A2D;
