
--******************************************************************
--*   ::::::::::::                                                 *
--*   ANAVHDL.VHDL                                                 * 
--*   ::::::::::::                                                 *
--******************************************************************
--| The following package are directly used by ACS_SYS:
use work.COMPUTE_PACK.all;
use work.IO_PACK.all;
use STD.TEXTIO.all;

--******************************************************************
--*                                                                *
--*   ANAVHDL                                                      * SPEC
--*                                                                *
--******************************************************************
entity ANAVHDL is
   port (v_output : out VALUE_ARRAY;
         T_IN     : out TIME;
         stop     : out TIME;
         incri    : out TIME;
         Vgs      : out real;
         extern_feed : in boolean;
         FILE_FLAG : BOOLEAN;
         lowpass_feed : in boolean;
         lowpass_input : in VALUE_ARRAY;
         error_value : in VALUE_ARRAY);
end ANAVHDL;
--| Purpose
--

--******************************************************************
--*                                                                *
--*   ANAVHDL                                                      * BODY
--*                                                                *
--******************************************************************         
architecture ANAVHDL of ANAVHDL is
  signal V  : VALUE_ARRAY(1 to 100);
  signal VR : VALUE_ARRAY(1 to 100);
  signal KIK: BOOLEAN := FALSE;
  signal READ_DONE: BOOLEAN := FALSE;
  signal TIME_SYNCH : BIT := '0';
  signal external_feed : boolean;
  signal error_value1 : real;

  begin

  --| process START is only for the purpose of activating the MAIN 
  --| process since no signals enter the ANAVHDL from entity; 
  START: process
    begin
      KIK <= TRUE;
      wait;
    end process;

  --| process MAIN handles the procedure calls at different situation
  --| and carry out the results according to user's requirment; 
  MAIN : process
    --| The following data structure created for storing the circuit 
    --| parameters provided by user from input file for simulation.
    variable R        : VALUE_ARRAY(1 to 100);
    variable NR1      : NODE_ARRAY(1 to 100);
    variable NR2      : NODE_ARRAY(1 to 100);
    variable C        : VALUE_ARRAY(1 to 100);
    variable NC1      : NODE_ARRAY(1 to 100);
    variable NC2      : NODE_ARRAY(1 to 100);
    variable L        : VALUE_ARRAY(1 to 100);
    variable NL1      : NODE_ARRAY(1 to 100); 
    variable NL2      : NODE_ARRAY(1 to 100); 
    variable ID       : VALUE_ARRAY(1 to 50);
    variable NI1      : NODE_ARRAY(1 to 50);
    variable NI2      : NODE_ARRAY(1 to 50);
    variable IP1      : VALUE_ARRAY(1 to 10);
    variable IP2      : VALUE_ARRAY(1 to 10);
    variable NP1      : NODE_ARRAY(1 to 10);
    variable NP2      : NODE_ARRAY(1 to 10);
    variable VNAME    : NAME_ARRAY(1 to 10);
    variable VD       : VALUE_ARRAY(1 to 50);
    variable NV1      : NODE_ARRAY(1 to 50);
    variable NV2      : NODE_ARRAY(1 to 50);
    variable PVNAME   : NAME_ARRAY(1 to 10);
    variable VP1      : VALUE_ARRAY(1 to 10);
    variable VP2      : VALUE_ARRAY(1 to 10);
    variable NVP1     : NODE_ARRAY(1 to 10);
    variable NVP2     : NODE_ARRAY(1 to 10);
    variable TDI      : TIME_ARRAY(1 to 10);
    variable TRI      : TIME_ARRAY(1 to 10);
    variable TFI      : TIME_ARRAY(1 to 10);
    variable PWI      : TIME_ARRAY(1 to 10);
    variable PERI     : TIME_ARRAY(1 to 10);
    variable TDV      : TIME_ARRAY(1 to 10);
    variable TRV      : TIME_ARRAY(1 to 10);
    variable TFV      : TIME_ARRAY(1 to 10);
    variable PWV      : TIME_ARRAY(1 to 10);
    variable PERV     : TIME_ARRAY(1 to 10);
    variable TSTEP    : TIME;
    variable TSTOP    : TIME;
    variable TNOM     : REAL := 300.15;
    variable MNAME    :  NAME_ARRAY(1 to 50);
    variable ND       :  NODE_ARRAY(1 to 50);
    variable NG       :  NODE_ARRAY(1 to 50);
    variable NS1      :  NODE_ARRAY(1 to 50);
    variable NB       :  NODE_ARRAY(1 to 50);
    variable CHANNEL_L:  VALUE_ARRAY(1 to 50);
    variable CHANNEL_W:  VALUE_ARRAY(1 to 50);
    variable AD       :  VALUE_ARRAY(1 to 50);
    variable AS       :  VALUE_ARRAY(1 to 50);
    variable PD       :  VALUE_ARRAY(1 to 50);
    variable PS       :  VALUE_ARRAY(1 to 50);
    variable NRD      :  VALUE_ARRAY(1 to 50);
    variable NRS      :  VALUE_ARRAY(1 to 50);
    variable OFF      :  VALUE_ARRAY(1 to 50);
    variable IC_TRAN  :  VALUE_ARRAY(1 to 50);
    variable Vbi0     :  VALUE_ARRAY(1 to 50);
    variable MODEL_NAME:  NAME_ARRAY(1 to 6);
    variable MODEL_TYPE:  NAME_ARRAY(1 to 6);
    variable MODEL_PARA:  PARAM_MATRIX;
    variable PNAME    : NAME_ARRAY(1 to 10);
    variable VPRIN    : NODE_ARRAY(1 to 10);
    variable IPRIN1   : NODE_ARRAY(1 to 10);
    variable IPRIN2   : NODE_ARRAY(1 to 10);
    variable VPRINC   : INTEGER := 0;
    variable IPRINC   : INTEGER := 0;
    variable MODCOUNT : INTEGER := 0;
    variable MCOUNT   : INTEGER := 0;
    --| The following data structure created for storing the intermediate 
    --| information during the simulation; 
    variable RNR1     : NODE_ARRAY(1 to 100);
    variable RNR2     : NODE_ARRAY(1 to 100);
    variable RNC1     : NODE_ARRAY(1 to 100);
    variable RNC2     : NODE_ARRAY(1 to 100);
    variable RNL1     : NODE_ARRAY(1 to 100);
    variable RNL2     : NODE_ARRAY(1 to 100);
    variable RNI1     : NODE_ARRAY(1 to 50);
    variable RNI2     : NODE_ARRAY(1 to 50);
    variable RNV1     : NODE_ARRAY(1 to 50);
    variable RNV2     : NODE_ARRAY(1 to 50);
    variable RNP1     : NODE_ARRAY(1 to 10);
    variable RNP2     : NODE_ARRAY(1 to 10);
    variable RNVP1    : NODE_ARRAY(1 to 10);
    variable RNVP2    : NODE_ARRAY(1 to 10);
    variable RND      : NODE_ARRAY(1 to 50);
    variable RNG      : NODE_ARRAY(1 to 50);
    variable RNS1     : NODE_ARRAY(1 to 50);
    variable RNB      : NODE_ARRAY(1 to 50);
    variable NR01     : NODE_ARRAY(1 to 100);
    variable NR02     : NODE_ARRAY(1 to 100);
    variable NC01     : NODE_ARRAY(1 to 100);
    variable NC02     : NODE_ARRAY(1 to 100);
    variable NL01     : NODE_ARRAY(1 to 100);
    variable NL02     : NODE_ARRAY(1 to 100);
    variable NI01     : NODE_ARRAY(1 to 50);
    variable NI02     : NODE_ARRAY(1 to 50);
    variable NV01     : NODE_ARRAY(1 to 50);
    variable NV02     : NODE_ARRAY(1 to 50);
    variable NP01     : NODE_ARRAY(1 to 10);
    variable NP02     : NODE_ARRAY(1 to 10);
    variable NVP01    : NODE_ARRAY(1 to 10);
    variable NVP02    : NODE_ARRAY(1 to 10);
    variable TDI0     : VALUE_ARRAY(1 to 10);
    variable TRI0     : VALUE_ARRAY(1 to 10);
    variable TFI0     : VALUE_ARRAY(1 to 10);
    variable PWI0     : VALUE_ARRAY(1 to 10);
    variable PERI0    : VALUE_ARRAY(1 to 10);
    variable TDV0     : VALUE_ARRAY(1 to 10);
    variable TRV0     : VALUE_ARRAY(1 to 10);
    variable TFV0     : VALUE_ARRAY(1 to 10);
    variable PWV0     : VALUE_ARRAY(1 to 10);
    variable PERV0    : VALUE_ARRAY(1 to 10);
    variable ND0      : NODE_ARRAY(1 to 50);
    variable NG0      : NODE_ARRAY(1 to 50);
    variable NS10     : NODE_ARRAY(1 to 50);
    variable NB0      : NODE_ARRAY(1 to 50);
    variable RCOUNT   : INTEGER := 0;
    variable CCOUNT   : INTEGER := 0;
    variable LCOUNT   : INTEGER := 0;
    variable ICOUNT   : INTEGER := 0;
    variable VCOUNT   : INTEGER := 0;
    variable PICOUNT  : INTEGER := 0;
    variable PVCOUNT  : INTEGER := 0;
    variable RNUM     : INTEGER := 0;
    variable NRNUM    : INTEGER := 0;
    variable COUNT    : INTEGER := 0;
    variable NONCON   : INTEGER := 0;
    variable TAG,ITFLG: INTEGER := 0;
    variable IMEM     : VALUE_ARRAY(1 to 100);
    variable VMEM     : VALUE_ARRAY(1 to 100);
    variable I0       : VALUE_ARRAY(1 to 100);
    variable VT       : VALUE_ARRAY(1 to 100);
    variable IOUT     : VALUE_ARRAY(1 to 100);
    variable VOUT     : VALUE_ARRAY(1 to 100);
    variable IOUT1    : VALUE_ARRAY(1 to 100);
    variable VOUT1    : VALUE_ARRAY(1 to 100);
    variable IOUT2    : VALUE_ARRAY(1 to 100);
    variable VOUT2    : VALUE_ARRAY(1 to 100);
    variable VOP      : VALUE_ARRAY(1 to 100);
    variable VDC      : VALUE_ARRAY(1 to 100);
    variable IC       : VALUE_ARRAY(1 to 100);
    variable IL       : VALUE_ARRAY(1 to 100);
    variable QGS      : CHARG_ARRAY(1 to 50);
    variable QGD      : CHARG_ARRAY(1 to 50);
    variable QGB      : CHARG_ARRAY(1 to 50);
    variable QBD      : CHARG_ARRAY(1 to 50);
    variable QBS      : CHARG_ARRAY(1 to 50);
    variable CCAPGS   : CHARG_ARRAY(1 to 50);
    variable CCAPGD   : CHARG_ARRAY(1 to 50);
    variable CCAPGB   : CHARG_ARRAY(1 to 50);
    variable CQBS     : CHARG_ARRAY(1 to 50);
    variable CQBD     : CHARG_ARRAY(1 to 50);
    variable VBS0     : VALUE_ARRAY(1 to 50);
    variable VBD0     : VALUE_ARRAY(1 to 50);
    variable VGS0     : VALUE_ARRAY(1 to 50);
    variable VDS0     : VALUE_ARRAY(1 to 50);
    variable VON0     : VALUE_ARRAY(1 to 50);
    variable VDSAT0   : VALUE_ARRAY(1 to 50);
    variable VBS01    : VALUE_ARRAY(1 to 50);
    variable VGS01    : VALUE_ARRAY(1 to 50);
    variable VDS01    : VALUE_ARRAY(1 to 50);
    variable ccap0    : ncap_array(1 to 50);
    variable qcap0    : ncap_array(1 to 50);
    variable DC_TAG   : BOOLEAN := TRUE;
    variable T,TSTEPV : TIME;
    variable TV,DELT,x,y,z,p,x0,y0,STEPV,STEPV_2 : REAL :=0.0;
    variable K        : LINE; 
    variable I        : POSITIVE;
    variable MAX,outflg : INTEGER := 0;
    variable S        : INTEGER := 1;
    variable q        : integer := 1;

file FILE2 :TEXT is out "STD_OUTPUT";

    begin

     --| Time synchronization for each iteration;
     wait on TIME_SYNCH, KIK; 
     --| Read the circuit parameters from user input file and store 
     --| into the data structure created above;
     Vgs <= VGS0(S); 
     if not READ_DONE then
       READ_FILE(R,NR1,NR2,C,NC1,NC2,L,NL1,NL2,ID,NI1,
	 NI2,VNAME,VD,NV1,NV2,IP1,IP2,NP1,NP2,TDI,TRI,
	 TFI,PWI,PERI,PVNAME,VP1,VP2,NVP1,NVP2,TDV,TRV,
         TFV,PWV,PERV,TSTEP,TSTOP,TNOM,MNAME,
         ND,NG,NS1,NB,CHANNEL_L,CHANNEL_W,AD,AS,PD,PS,
         NRD,NRS,OFF,IC_TRAN,MODEL_NAME,MODEL_TYPE,
         MODEL_PARA,PNAME,VPRIN,IPRIN1,IPRIN2,VPRINC,
         IPRINC,RNUM,RCOUNT,CCOUNT,LCOUNT,ICOUNT,VCOUNT,
         PICOUNT,PVCOUNT,MODCOUNT,MCOUNT,FILE_FLAG);
       READ_DONE <= TRUE;
     end if;
     --| First step: DC operating point calculation;
     if DC_TAG then 
       RNR1 := NR1;
       RNR2 := NR2;
       RNC1 := NC1;
       RNC2 := NC2;
       RNL1 := NL1;
       RNL2 := NL2;
       RNI1 := NI1;
       RNI2 := NI2;
       RNP1 := NP1;
       RNP2 := NP2;
       RNV1 := NV1;
       RNV2 := NV2;
       RNVP1:= NVP1;
       RNVP2:= NVP2;
       RND  := ND;
       RNG  := NG;
       RNS1 := NS1;
       RNB  := NB;
       NRNUM:= RNUM;
       if VCOUNT /=0 or PVCOUNT /= 0 then
         NODE_RENUMA(RNUM,VCOUNT,ICOUNT,PVCOUNT,
	   PICOUNT,RCOUNT,CCOUNT,LCOUNT,MCOUNT,
	   RNV1,RNV2,RNVP1,RNVP2,RNR1,RNR2,RNC1,
	   RNC2,RNL1,RNL2,RND,RNG,RNS1,RNB,RNI1,
           RNI2,RNP1,RNP2);
       end if;
       NR01 := RNR1;
       NR02 := RNR2;
       NC01 := RNC1;
       NC02 := RNC2;
       NL01 := RNL1;
       NL02 := RNL2;
       NI01 := RNI1;
       NI02 := RNI2;
       NP01 := RNP1;
       NP02 := RNP2;
       NV01 := RNV1; 
       NV02 := RNV2; 
       NVP01:= RNVP1;
       NVP02:= RNVP2;
       ND0  := RND;
       NG0  := RNG;
       NS10 := RNS1;
       NB0  := RNB;
       if LCOUNT /= 0 then
         NODE_RENUMB(VCOUNT,ICOUNT,PVCOUNT,PICOUNT,
	   RCOUNT,CCOUNT,LCOUNT,MCOUNT,NRNUM,NV01,
	   NV02,NVP01,NVP02,NR01,NR02,NC01,NC02,NL01,
	   NL02,NI01,NI02,NP01,NP02,ND0,NG0,NS10,NB0);
       end if;
       if NRNUM /= 0 then
	 DC_POINT(R,NR01,NR02,ID,NI01,NI02,IP1,
	   NP01,NP02,VD,NV01,NV02,VP1,NVP01,
           NVP02,MNAME,ND0,NG0,NS10,NB0,CHANNEL_L,
           CHANNEL_W,AD,AS,PD,PS,NRD,NRS,OFF,IC_TRAN,
           MODEL_NAME,MODEL_TYPE,MODEL_PARA,NRNUM,
           RCOUNT,CCOUNT,LCOUNT,VCOUNT,ICOUNT,PVCOUNT,
	   PICOUNT,MCOUNT,MODCOUNT,TNOM,VBS0,VBD0,VGS0,
           VDS0,VON0,VDSAT0,Vbi0,I0,VOP);
         VDC := VOP;
	 if LCOUNT /= 0 then
	   NODE_BACKNUMDC(NR01,NR02,RNR1,RNR2,
	     RCOUNT,VOP,VDC);
	 end if;
         VT := VDC;
         VOUT:=VDC;
	 if VCOUNT /= 0 or PVCOUNT /= 0 then
	   NODE_BACKNUMTR(RNR1,RNR2,NR1,NR2,RCOUNT,RND,RNG,RNS1,RNB,
             ND,NG,NS1,NB,MCOUNT,I0,VDC);
	 end if;
       else
         loop1:
         for I in 1 to RNUM loop
	   VDC(I) := 0.0;
	 end loop loop1;
       end if; 
       T := NOW;
       OUTPUT_FORMATDC(VDC,I0,PNAME,IPRIN1,
         IPRIN2,IPRINC,RNUM);
       OUTPUT_FORMATTR(VDC,I0,T,VPRIN,PNAME,IPRIN1,
         IPRIN2,VPRINC,IPRINC);
       TAG := 0;	
       if PICOUNT > 0 then        
         loop2:
         for I in 1 to PICOUNT loop
           TDI0(I)  := TIME_TO_REAL(TDI(I)); 
           TRI0(I)  := TIME_TO_REAL(TRI(I));     
           TFI0(I)  := TIME_TO_REAL(TFI(I));    
           PWI0(I)  := TIME_TO_REAL(PWI(I));      
           PERI0(I) := TIME_TO_REAL(PERI(I));
         end loop loop2;
       end if;
       if PVCOUNT > 0 then
         loop3:
         for I in 1 to PVCOUNT loop
           TDV0(I)  := TIME_TO_REAL(TDV(I));     
           TRV0(I)  := TIME_TO_REAL(TRV(I));      
           TFV0(I)  := TIME_TO_REAL(TFV(I));   
           PWV0(I)  := TIME_TO_REAL(PWV(I)); 
           PERV0(I) := TIME_TO_REAL(PERV(I));
         end loop loop3;
       end if;
       loop4:
       for I in 1 to RNUM loop
         VR(I) <= 0.0;
         V(I)  <= 0.0;
       end loop loop4;
       wait for 0 ns;
       DC_TAG := FALSE;
     end if;                             

     --| Transient analysis at each time step;
     if NOW <  TSTOP then
       external_feed <= extern_feed;
       if external_feed = true then
           wait for 0 ns;
           VT := error_value;
       elsif lowpass_feed = true then
           VT := lowpass_input; 
           q := q + 1;
       end if;
       T := NOW;                          
       T_IN <= T;
       TV := TIME_TO_REAL(T);           
       TRAN_ANA(R,RNR1,RNR2,C,RNC1,RNC2,L,RNL1,RNL2,
         ID,RNI1,RNI2,IP1,IP2,RNP1,RNP2,TDI0,TRI0,
         TFI0,PWI0,PERI0,VD,RNV1,RNV2,VP1,VP2,RNVP1,
         RNVP2,TDV0,TRV0,TFV0,PWV0,PERV0,MNAME,RND,RNG,
         RNS1,RNB,CHANNEL_L,CHANNEL_W,AD,AS,PD,PS,NRD,
         NRS,OFF,IC_TRAN,MODEL_NAME,MODEL_TYPE,MODEL_PARA,
         RNUM,RCOUNT,CCOUNT,LCOUNT,VCOUNT,ICOUNT,PVCOUNT,
         PICOUNT,MCOUNT,MODCOUNT,TNOM,TV,DELT,STEPV,STEPV_2,TSTOP,TSTEP,
         Vbi0,NONCON,IMEM,VMEM,I0,VT,IOUT,VOUT,IOUT1,VOUT1,IOUT2,VOUT2,
         IC,IL,QGS,QGD,QGB,QBD,QBS,CCAPGS,CCAPGD,CCAPGB,CQBS,CQBD,VBS0,
         VBD0,VGS0,VDS0,VON0,VDSAT0,VBS01,VGS01,VDS01,ccap0,qcap0,
         outflg,ITFLG,MAX,TAG);
       VOP := VOUT;
       if VCOUNT /= 0 or PVCOUNT /= 0 then
         NODE_BACKNUMTR(RNR1,RNR2,NR1,NR2,RCOUNT,RND,RNG,RNS1,RNB,
           ND,NG,NS1,NB,MCOUNT,I0,VOP);
       end if;
       VR <= VOP;                            
       V  <= VR after TSTEP;         
       wait for 0 ns;
       v_output <= VR;
       stop <= TSTOP;
       incri <= TSTEP;
       wait for 0 ns;
       T  := NOW + TSTEP;
       OUTPUT_FORMATTR(VR,I0,T,VPRIN,PNAME,IPRIN1,
         IPRIN2,VPRINC,IPRINC);
     end if;

    end process;

  --| Time synchronization with MAIN process;
  TIMESYNCH : process
    begin
      wait on V'TRANSACTION;
      TIME_SYNCH <= not TIME_SYNCH ; 
    end process;
 
  end ANAVHDL;
