
--************************************************************
--*    ::::::::::::                                          *
--*    IO_PACK.VHDL                                          *
--*    ::::::::::::                                          *
--************************************************************
--| The following packages are directly used by IO_PACK:
library MCC; use MCC.C_INTERFACE.all;
use STD.TEXTIO.all;
use work.COMPUTE_PACK.all;
package IO_PACK is
--| Purpose
--

--************************************************************
--*                                                          *
--*    READ_FILE                                             * SPEC
--*                                                          *
--************************************************************
  procedure READ_FILE
   (R         : inout VALUE_ARRAY(1 to 100);
    NR1       : inout NODE_ARRAY(1 to 100);
    NR2       : inout NODE_ARRAY(1 to 100);
    C         : inout VALUE_ARRAY(1 to 100);
    NC1       : inout NODE_ARRAY(1 to 100);
    NC2       : inout NODE_ARRAY(1 to 100);
    L         : inout VALUE_ARRAY(1 to 100);
    NL1       : inout NODE_ARRAY(1 to 100);
    NL2       : inout NODE_ARRAY(1 to 100);
    ID        : inout VALUE_ARRAY(1 to 50);
    NI1       : inout NODE_ARRAY(1 to 50);
    NI2       : inout NODE_ARRAY(1 to 50);
    VNAME     : inout NAME_ARRAY(1 to 10);
    VD        : inout VALUE_ARRAY(1 to 50);
    NV1       : inout NODE_ARRAY(1 to 50);
    NV2       : inout NODE_ARRAY(1 to 50);
    IP1       : inout VALUE_ARRAY(1 to 10);
    IP2       : inout VALUE_ARRAY(1 to 10);
    NP1       : inout NODE_ARRAY(1 to 10);
    NP2       : inout NODE_ARRAY(1 to 10);
    TDI       : inout TIME_ARRAY(1 to 10);
    TRI       : inout TIME_ARRAY(1 to 10);
    TFI       : inout TIME_ARRAY(1 to 10);
    PWI       : inout TIME_ARRAY(1 to 10);
    PERI      : inout TIME_ARRAY(1 to 10);
    PVNAME    : inout NAME_ARRAY(1 to 10);
    VP1       : inout VALUE_ARRAY(1 to 10);
    VP2       : inout VALUE_ARRAY(1 to 10);
    NVP1      : inout NODE_ARRAY(1 to 10);
    NVP2      : inout NODE_ARRAY(1 to 10);
    TDV       : inout TIME_ARRAY(1 to 10);
    TRV       : inout TIME_ARRAY(1 to 10);
    TFV       : inout TIME_ARRAY(1 to 10);
    PWV       : inout TIME_ARRAY(1 to 10);
    PERV      : inout TIME_ARRAY(1 to 10);
    STEP      : inout TIME;
    CYCLETIME : inout TIME;
--    RELTOL    : inout REAL;
--    VNTOL     : inout REAL;
    TNOM      : inout REAL;
    MNAME     : inout NAME_ARRAY(1 to 50);  
    ND        : inout NODE_ARRAY(1 to 50);
    NG        : inout NODE_ARRAY(1 to 50);
    NS1       : inout NODE_ARRAY(1 to 50);
    NB        : inout NODE_ARRAY(1 to 50);
    CHANNEL_L : inout VALUE_ARRAY(1 to 50);
    CHANNEL_W : inout VALUE_ARRAY(1 to 50);
    AD        : inout VALUE_ARRAY(1 to 50);
    AS        : inout VALUE_ARRAY(1 to 50);
    PD        : inout VALUE_ARRAY(1 to 50);
    PS        : inout VALUE_ARRAY(1 to 50);
    NRD       : inout VALUE_ARRAY(1 to 50);
    NRS       : inout VALUE_ARRAY(1 to 50);
    OFF       : inout VALUE_ARRAY(1 to 50);
    IC_TRAN   : inout VALUE_ARRAY(1 to 50);
    MODEL_NAME: inout NAME_ARRAY(1 to 6);
    MODEL_TYPE: inout NAME_ARRAY(1 to 6);
    MODEL_PARA: inout PARAM_MATRIX;
    PNAME     : inout NAME_ARRAY(1 to 10);
    VPRIN     : inout NODE_ARRAY(1 to 10);
    IPRIN1    : inout NODE_ARRAY(1 to 10);
    IPRIN2    : inout NODE_ARRAY(1 to 10);
    VPRINC    : inout INTEGER;
    IPRINC    : inout INTEGER;
    RNUM      : inout INTEGER;
    RCOUNT    : inout INTEGER;
    CCOUNT    : inout INTEGER;
    LCOUNT    : inout INTEGER;
    ICOUNT    : inout INTEGER;
    VCOUNT    : inout INTEGER;
    PICOUNT   : inout INTEGER;
    PVCOUNT   : inout INTEGER;
    MODCOUNT  : inout INTEGER;
    MCOUNT    : inout INTEGER;
    FILE_FLAG : BOOLEAN);
--| Purpose
--|

--***********************************************************
--*                                                         *
--*   NODE_RENUMA                                           * SPEC
--*                                                         *
--***********************************************************
  procedure NODE_RENUMA
   (RNUM    : in INTEGER;
    VCOUNT  : in INTEGER;
    ICOUNT  : in INTEGER;
    PVCOUNT : in INTEGER;
    PICOUNT : in INTEGER;
    RCOUNT  : in INTEGER;
    CCOUNT  : in INTEGER;
    LCOUNT  : in INTEGER;
    MCOUNT  : in INTEGER;
    RNV1    : inout NODE_ARRAY;
    RNV2    : inout NODE_ARRAY;
    RNVP1   : inout NODE_ARRAY;
    RNVP2   : inout NODE_ARRAY;
    RNR1    : inout NODE_ARRAY;
    RNR2    : inout NODE_ARRAY;
    RNC1    : inout NODE_ARRAY;
    RNC2    : inout NODE_ARRAY;
    RNL1    : inout NODE_ARRAY;
    RNL2    : inout NODE_ARRAY;
    RND     : inout NODE_ARRAY;
    RNG     : inout NODE_ARRAY;
    RNS1    : inout NODE_ARRAY;
    RNB     : inout NODE_ARRAY;
    RNI1    : inout NODE_ARRAY;
    RNI2    : inout NODE_ARRAY;
    RNP1    : inout NODE_ARRAY;
    RNP2    : inout NODE_ARRAY);
--| purpose
--|

--**********************************************************
--*                                                        *
--*   NODE_RENUMB                                          * SPEC
--*                                                        *
--**********************************************************
  procedure NODE_RENUMB
   (VCOUNT  : in INTEGER;
    ICOUNT  : in INTEGER;
    PVCOUNT : in INTEGER;
    PICOUNT : in INTEGER;
    RCOUNT  : in INTEGER;
    CCOUNT  : in INTEGER;
    LCOUNT  : in INTEGER;
    MCOUNT  : in INTEGER;
    NRNUM   : inout INTEGER;
    RNV1    : inout NODE_ARRAY;
    RNV2    : inout NODE_ARRAY;
    RNVP1   : inout NODE_ARRAY;
    RNVP2   : inout NODE_ARRAY;
    RNR1    : inout NODE_ARRAY;
    RNR2    : inout NODE_ARRAY;
    RNC1    : inout NODE_ARRAY;
    RNC2    : inout NODE_ARRAY;
    RNL1    : inout NODE_ARRAY;
    RNL2    : inout NODE_ARRAY;
    RNI1    : inout NODE_ARRAY;
    RNI2    : inout NODE_ARRAY;
    RNP1    : inout NODE_ARRAY;
    RNP2    : inout NODE_ARRAY;
    RND     : inout NODE_ARRAY;
    RNG     : inout NODE_ARRAY;
    RNS1    : inout NODE_ARRAY;
    RNB     : inout NODE_ARRAY);

--***********************************************************
--*                                                         *
--*   NODE_BACKNUMDC                                        * SPEC
--*                                                         *
--***********************************************************
  procedure NODE_BACKNUMDC
   (RNR1    : in NODE_ARRAY;
    RNR2    : in NODE_ARRAY;
    NR1     : in NODE_ARRAY;
    NR2     : in NODE_ARRAY;
    RCOUNT  : in INTEGER;
    VOP     : in VALUE_ARRAY;
    V       : inout VALUE_ARRAY);
--| purpose
--|

--***********************************************************
--*                                                         *
--*   NODE_BACKNUMTR                                        * SPEC
--*                                                         *
--***********************************************************
  procedure NODE_BACKNUMTR
   (RNR1    : in NODE_ARRAY;
    RNR2    : in NODE_ARRAY;
    NR1     : in NODE_ARRAY;
    NR2     : in NODE_ARRAY;
    RCOUNT  : in INTEGER;
    RND     : in NODE_ARRAY;
    RNG     : in NODE_ARRAY;
    RNS1    : in NODE_ARRAY;
    RNB     : in NODE_ARRAY;
    ND      : in NODE_ARRAY;
    NG      : in NODE_ARRAY;
    NS1     : in NODE_ARRAY;
    NB      : in NODE_ARRAY;
    MCOUNT  : in INTEGER;
    I       : inout VALUE_ARRAY;
    V       : inout VALUE_ARRAY);
--|purpose
--|

--***********************************************************
--*                                                         *
--*   OUTPUT_FORMATDC                                       * SPEC
--*                                                         *
--***********************************************************
  procedure OUTPUT_FORMATDC
   (VDC    : in VALUE_ARRAY;
    IDC    : in VALUE_ARRAY;
    PNAME  : in NAME_ARRAY;
    IPRIN1 : in NODE_ARRAY;
    IPRIN2 : in NODE_ARRAY;
    IPRINC : in INTEGER;
    RNUM   : in INTEGER);
--| purpose
--|  

--***********************************************************
--*                                                         *
--*   OUTPUT_FORMATTR                                       * SPEC
--*                                                         *
--***********************************************************
  procedure OUTPUT_FORMATTR
   (V      : in VALUE_ARRAY;
    I      : in VALUE_ARRAY;
    T      : in TIME;
    VPRIN  : in NODE_ARRAY;
    PNAME  : in NAME_ARRAY;
    IPRIN1 : in NODE_ARRAY;
    IPRIN2 : in NODE_ARRAY;
    VPRINC : in INTEGER;
    IPRINC : in INTEGER);

end IO_PACK;

--***********************************************************
--*                                                         *
--*   READ_FILE                                             * BODY 
--*                                                         *
--***********************************************************
package body IO_PACK is

  procedure READ_FILE
   (R         : inout VALUE_ARRAY(1 to 100);    
    NR1       : inout NODE_ARRAY(1 to 100);  
    NR2       : inout NODE_ARRAY(1 to 100); 
    C         : inout VALUE_ARRAY(1 to 100);     
    NC1       : inout NODE_ARRAY(1 to 100);   
    NC2       : inout NODE_ARRAY(1 to 100);   
    L         : inout VALUE_ARRAY(1 to 100);
    NL1       : inout NODE_ARRAY(1 to 100);
    NL2       : inout NODE_ARRAY(1 to 100);
    ID        : inout VALUE_ARRAY(1 to 50);
    NI1       : inout NODE_ARRAY(1 to 50);
    NI2       : inout NODE_ARRAY(1 to 50);
    VNAME     : inout NAME_ARRAY(1 to 10);
    VD        : inout VALUE_ARRAY(1 to 50);
    NV1       : inout NODE_ARRAY(1 to 50);
    NV2       : inout NODE_ARRAY(1 to 50);
    IP1       : inout VALUE_ARRAY(1 to 10);
    IP2       : inout VALUE_ARRAY(1 to 10);
    NP1       : inout NODE_ARRAY(1 to 10);
    NP2       : inout NODE_ARRAY(1 to 10);
    TDI       : inout TIME_ARRAY(1 to 10);
    TRI       : inout TIME_ARRAY(1 to 10);
    TFI       : inout TIME_ARRAY(1 to 10);
    PWI       : inout TIME_ARRAY(1 to 10);
    PERI      : inout TIME_ARRAY(1 to 10);
    PVNAME    : inout NAME_ARRAY(1 to 10);
    VP1       : inout VALUE_ARRAY(1 to 10);
    VP2       : inout VALUE_ARRAY(1 to 10);
    NVP1      : inout NODE_ARRAY(1 to 10);
    NVP2      : inout NODE_ARRAY(1 to 10);
    TDV       : inout TIME_ARRAY(1 to 10);
    TRV       : inout TIME_ARRAY(1 to 10);
    TFV       : inout TIME_ARRAY(1 to 10);
    PWV       : inout TIME_ARRAY(1 to 10);
    PERV      : inout TIME_ARRAY(1 to 10);
    STEP      : inout TIME;
    CYCLETIME : inout TIME;
--    RELTOL    : inout REAL;
--    VNTOL     : inout REAL;
    TNOM      : inout REAL;
    MNAME     : inout NAME_ARRAY(1 to 50);
    ND        : inout NODE_ARRAY(1 to 50);
    NG        : inout NODE_ARRAY(1 to 50);
    NS1       : inout NODE_ARRAY(1 to 50);
    NB        : inout NODE_ARRAY(1 to 50);
    CHANNEL_L : inout VALUE_ARRAY(1 to 50); 
    CHANNEL_W : inout VALUE_ARRAY(1 to 50); 
    AD        : inout VALUE_ARRAY(1 to 50);
    AS        : inout VALUE_ARRAY(1 to 50);
    PD        : inout VALUE_ARRAY(1 to 50);
    PS        : inout VALUE_ARRAY(1 to 50);
    NRD       : inout VALUE_ARRAY(1 to 50);
    NRS       : inout VALUE_ARRAY(1 to 50);
    OFF       : inout VALUE_ARRAY(1 to 50);
    IC_TRAN   : inout VALUE_ARRAY(1 to 50);
    MODEL_NAME: inout NAME_ARRAY(1 to 6);
    MODEL_TYPE: inout NAME_ARRAY(1 to 6);
    MODEL_PARA: inout PARAM_MATRIX;
    PNAME     : inout NAME_ARRAY(1 to 10);
    VPRIN     : inout NODE_ARRAY(1 to 10);
    IPRIN1    : inout NODE_ARRAY(1 to 10);
    IPRIN2    : inout NODE_ARRAY(1 to 10);
    VPRINC    : inout INTEGER;
    IPRINC    : inout INTEGER;
    RNUM      : inout INTEGER;
    RCOUNT    : inout INTEGER;
    CCOUNT    : inout INTEGER;
    LCOUNT    : inout INTEGER;
    ICOUNT    : inout INTEGER;
    VCOUNT    : inout INTEGER;
    PICOUNT   : inout INTEGER;
    PVCOUNT   : inout INTEGER;
    MODCOUNT  : inout INTEGER;
    MCOUNT    : inout INTEGER;
    FILE_FLAG : BOOLEAN)
  is
    file FILE1        : TEXT is in "INPUT.TEXTIO1";
    file FILE3        : TEXT is in "INPUT.TEXTIO2";
    file FILE2        : TEXT is out "STD_OUTPUT";
    variable NAME     : ELEMENT_NAME; 
    variable NODE1    : INTEGER;
    variable NODE2    : INTEGER;
    variable VALUE    : REAL;
    variable EUNIT    : ELEMENT_NAME;
    variable CHAR     : ELEMENT_NAME;
    variable IDENTY   : TEXTIO_FLAG;
    variable END_LINE : BOOLEAN;
    variable k        : LINE;
    variable NCH      : CHARACTER;
    variable TN       : TIME;
    variable I        : INTEGER := 0;
    variable BLANK    : INTEGER := 0;
    variable CC       : INTEGER := 0;
  begin

    loop00:
    for I in 1 to 100 loop
      R(I)   := 0.0;     
      NR1(I) := 0;   
      NR2(I) := 0;
      C(I)   := 0.0;        
      NC1(I) := 0; 
      NC2(I) := 0; 
      L(I)   := 0.0; 
      NL1(I) := 0;
      NL2(I) := 0; 
    end loop loop00;
    loop01:
    for I in 1 to 50 loop
      ID(I)  := 0.0; 
      NI1(I) := 0; 
      NI2(I) := 0; 
      VD(I)  := 0.0;
      NV1(I) := 0; 
      NV2(I) := 0;
      ND(I)  := 0;
      NG(I)  := 0;
      NS1(I) := 0;
      NB(I)  := 0;
      CHANNEL_L(I) := 0.0;
      CHANNEL_W(I) := 0.0;
      AD(I)  := 0.0;
      AS(I)  := 0.0;
      PD(I)  := 0.0;
      PS(I)  := 0.0;
      NRD(I) := 0.0;
      NRS(I) := 0.0;
    end loop loop01; 
    loop02:
    for I in 1 to 10 loop
      IP1(I) := 0.0; 
      IP2(I) := 0.0; 
      NP1(I) := 0; 
      NP2(I) := 0; 
      TDI(I) := 0 ns; 
      TRI(I) := 0 ns; 
      TFI(I) := 0 ns; 
      PWI(I) := 0 ns;
      PERI(I):= 0 ns; 
      VP1(I) := 0.0;
      VP2(I) := 0.0; 
      NVP1(I):= 0; 
      NVP2(I):= 0; 
      TDV(I) := 0 ns;
      TRV(I) := 0 ns; 
      TFV(I) := 0 ns; 
      PWV(I) := 0 ns; 
      PERV(I):= 0 ns;
      VPRIN(I)  := 0;
      IPRIN1(I) := 0;
      IPRIN2(I) := 0;
    end loop loop02; 
    loop03:
    for I in 1 to 42 loop
      loop04:
      for J in 1 to 6 loop
        MODEL_PARA(I,J) := 0.0;
      end loop loop04;
    end loop loop03;
    loop05:
    for I in 1 to 6 loop
      MODEL_PARA(3,I) := 2.0e-5;
      MODEL_PARA(5,I) := 0.63;
      MODEL_PARA(11,I):= 1.0e-14;
      MODEL_PARA(12,I):= 0.8;
      MODEL_PARA(18,I):= 0.5;
      MODEL_PARA(20,I):= 0.33;
      MODEL_PARA(21,I):= 1.0e-8;
      MODEL_PARA(22,I):= 1.0e-7; 
      MODEL_PARA(26,I):= 1.0; 
      MODEL_PARA(29,I):= 600.0; 
      MODEL_PARA(30,I):= 1.0e-4; 
      MODEL_PARA(34,I):= 1.0; 
      MODEL_PARA(35,I):= 1.0; 
      MODEL_PARA(37,I):= 1.0; 
      MODEL_PARA(38,I):= 0.5; 
      MODEL_PARA(42,I):= 0.2;
    end loop loop05;
    RNUM := 0;
    if FILE_FLAG = TRUE then
       readline (FILE1,k);
    else
       readline (FILE3,k);
    end if;
    --| Skip the first comment line in SPICE input deck;
    loop1:
       while (not ENDFILE(FILE1)) and (not ENDFILE(FILE3)) loop
        END_LINE := FALSE;
        loopAD:
        loop
        if FILE_FLAG = TRUE then
          readline (FILE1,k);
        else
          readline (FILE3,k);
        end if;
        read (k, NAME(1));
        exit loopAD when NAME(1) /= '*';
      end loop loopAD;
      if NAME(1) = 'R' then
      --| Element Card: resistor description; 
        IDENTY := 'R';
        RCOUNT := RCOUNT + 1;
        loop2a:
        for I in 2 to 8 loop
  	  read (k, NAME(I));
	  exit loop2a when NAME(I) = ' ';
	if NAME(I)=' ' then
	exit loop2a;
	end if;
        end loop loop2a;
        read (k, NODE1);
        if RNUM < NODE1 then
          RNUM := NODE1;
        end if; 
        read (k, NODE2);
        if RNUM < NODE2 then
       	  RNUM := NODE2;
        end if;
        NR1(RCOUNT) := NODE1;
        NR2(RCOUNT) := NODE2;
        read (k, VALUE);
        read (k, EUNIT(1));
        if EUNIT(1) = ' ' then
	  R(RCOUNT) := VALUE;
        elsif EUNIT(1) = 'K' or EUNIT(1) = 'k' then
	  R(RCOUNT) := 1000.0*VALUE;
        end if;
        --write(k,NR1(RCOUNT));
        --write(k,' ');
        --write(k,NR2(RCOUNT));
        --write(k,' ');
        --write(k,R(RCOUNT));
        --writeline(OUTPUT,k);
      elsif NAME(1) = 'C' then
      --| Element Card: capacitor description;
        IDENTY := 'C';
        loop2b:
        for I in 2 to 8 loop
	  read (k, NAME(I));
	  exit loop2b when NAME(I) = ' ';
	end loop loop2b;
	CCOUNT := CCOUNT + 1;
	read (k, NODE1);
	read (k, NODE2);
	read (k, VALUE);
	NC1(CCOUNT) := NODE1;
	NC2(CCOUNT) := NODE2;
	read (k, EUNIT(1));
	if EUNIT(1) = 'F' or EUNIT(1)= ' ' then
	  C(CCOUNT) := 1.0e-6*VALUE;
	elsif EUNIT(1) = 'U' then
	  C(CCOUNT) := 1000.0*VALUE;
	  read (k, EUNIT(2));
	elsif EUNIT(1) = 'P' then
	  C(CCOUNT) := 0.001*VALUE;
	  read (k, EUNIT(2));
	end if;
	--write(k,NC1(CCOUNT));
	--write(k,' ');
	--write(k,NC2(CCOUNT));
	--write(k,' ');
	--write(k,C(CCOUNT));
	--writeline(OUTPUT,k);
      elsif NAME(1) = 'L' then
      --| Element Card: inductor description;
        IDENTY := 'L';
        loop2c:
        for I in 2 to 8 loop
          read (k, NAME(I));
          exit loop2c when NAME(I) = ' ';
        end loop loop2c;
        LCOUNT := LCOUNT + 1;
	read (k, NODE1);
	read (k, NODE2);
	read (k, VALUE);
	NL1(LCOUNT) := NODE1;
	NL2(LCOUNT) := NODE2;
	read (k, EUNIT(1));
	if EUNIT(1) = 'H' or EUNIT(1)=' ' then
	  L(LCOUNT) := 1000000000.0*VALUE;
	elsif eunit(1) = 'U' then
	  L(LCOUNT) := 1000.0*VALUE;
	  read (k, EUNIT(2));
	elsif EUNIT(1) = 'P' then
	  L(LCOUNT) := 0.001*VALUE;
	  read (k, EUNIT(2));
	end if;
	--write(k,NL1(LCOUNT));
	--write(k,' ');
	--write(k,NL2(LCOUNT));
	--write(k,' ');
	--write(k,L(LCOUNT));
        --writeline(OUTPUT,k);
      elsif NAME(1) = 'V' or NAME(1) = 'v' then
      --| Element Card: independent voltage source description;
        IDENTY := 'V';
	loop2d:
	for I in 2 to 8 loop
	  read (k, NAME(I));
          CC := CC+1;
          if NAME(I) = ' ' then
            loop2dd:
            for J in I to 8 loop
              NAME(J) := ' ';
            end loop loop2dd; 
	    exit loop2d;
          end if;
	end loop loop2d;
	read (k, NODE1);
	read (k, NODE2);
	read (k, CHAR(1));
	if CHAR(1) = ' ' then
	  read (k, CHAR(1));
	end if;
	if CHAR(1) = 'D' then
        --| DC voltage source;
	  VCOUNT := VCOUNT+1;
          VNAME(VCOUNT) := NAME;
	  loop2e:
	  for I in 2 to 8 loop
	    read (k, CHAR(I));
	    exit loop2e when CHAR(I) = ' ';
	  end loop loop2e;
	  read (k, VALUE);
	  NV1(VCOUNT) := NODE1;
	  NV2(VCOUNT) := NODE2;
	  VD(VCOUNT)  := VALUE;
--          loop2ee:
--          for I in 1 to CC loop
--          write(k, NAME(I));
--          end loop loop2ee;
--          write(k, ' ');
--	  write(k, NV1(VCOUNT));
--	  write(k, ' ');
--	  write(k, NV2(VCOUNT));
--	  write(k, ' ');
--	  write(k, VD(VCOUNT));
--	  writeline(OUTPUT,k);
	elsif CHAR(1) = 'P' or CHAR(1) = 'p' then
        --| Pulse voltage source;
	  PVCOUNT := PVCOUNT + 1;
          PVNAME(PVCOUNT) := NAME;
	  loop2f:
	  for I in 2 to 8 loop
	    read (k, CHAR(I));
	    exit loop2f when CHAR(I) = '(';
	  end loop loop2f;
	  NVP1(PVCOUNT) := NODE1;
	  NVP2(PVCOUNT) := NODE2;
	  read (k, VALUE);
	  VP1(PVCOUNT) := VALUE;
	  read (k, VALUE);
	  VP2(PVCOUNT) := VALUE;
	  read (k, TN);
	  TDV(PVCOUNT) := TN;
	  read (k, TN);
	  TRV(PVCOUNT) := TN;
	  read (k, TN);
	  TFV(PVCOUNT) := TN;
	  read (k, TN);
	  PWV(PVCOUNT) := TN;
	  read (k, TN);
	  PERV(PVCOUNT) := TN;
	  read (k, NCH);            
--          loop2ff:
--          for I in 1 to CC loop
--            write(k, NAME(I));
--          end loop loop2ff;
--	  write(k, NVP1(PVCOUNT));
--	  write(k, ' ');
--	  write(k, NVP2(PVCOUNT));
--	  write(k, ' ');
--	  write(k, VP1(PVCOUNT));
--	  write(k, ' ');
--	  write(k, VP2(PVCOUNT));
--	  write(k, ' ');
--          write(k, TDV(PVCOUNT));
--	  write(k, ' ');
--          write(k, TRV(PVCOUNT));
--	  write(k, ' ');
--	  write(k, TFV(PVCOUNT));
--	  write(k, ' ');
--	  write(k, PWV(PVCOUNT));
--	  write(k, ' ');
--	  write(k, PERV(PVCOUNT));
--          writeline(OUTPUT,k);
	end if; 
        CC := 0;
      elsif NAME(1) = 'I' then
      --| Element Card: independent current source description; 
      IDENTY := 'I';
	loop2g:
	for I in 2 to 8 loop
	  read (k, NAME(I));
	  exit loop2g when NAME(I) = ' ';
	end loop loop2g;
	read (k, NODE1);
	read (k, NODE2);
	read (k, CHAR(1));
	if CHAR(1) = ' ' then
	  read (k, CHAR(1));
	end if;
	if CHAR(1) = 'D' then
        --| DC current source;
	  loop2h:
	  for I in 2 to 8 loop	
	    read (k, CHAR(I));
	    exit loop2h when CHAR(I)= ' ';
	  end loop loop2h;
	  ICOUNT := ICOUNT+1;
	  read (k, VALUE);
	  NI1(ICOUNT) := NODE1;
	  NI2(ICOUNT) := NODE2;
	  ID(ICOUNT)  := VALUE;
	--  write(k,NI1(ICOUNT));
	--  write(k,' ');
	--  write(k,NI2(ICOUNT));
	--  write(k,' ');
	--  write(k,ID(ICOUNT));
        --  writeline(OUTPUT,k);
	elsif CHAR(1) = 'P' then
        --| Pulse current source;
	  loop2i:
	  for I in 2 to 8 loop	
	    read (k, CHAR(I));
	    exit loop2i when CHAR(I)= '(';
	  end loop loop2i;
	  PICOUNT := PICOUNT + 1;
	  NP1(PICOUNT) := NODE1;
	  NP2(PICOUNT) := NODE2;
	  read (k, VALUE);
	  IP1(PICOUNT) := VALUE;
	  read (k, VALUE);
	  IP2(PICOUNT) := VALUE;
	  read (k, TN);
	  TDI(PICOUNT) := TN;
	  read (k, TN);
	  TRI(PICOUNT) := TN;
	  read (k, TN);
	  TFI(PICOUNT) := TN;
	  read (k, TN);
	  PWI(PICOUNT) := TN;
	  read (k, TN);
	  PERI(PICOUNT) := TN;           
	  read (k, NCH);
--	  write(k,NP1(PICOUNT));
--	  write(k,' ');
--	  write(k,NP2(PICOUNT));
--	  write(k,' ');
--	  write(k,IP1(PICOUNT));
--	  write(k,' ');
--	  write(k,IP2(PICOUNT));
--	  write(k,' ');
--	  write(k,TDI(PICOUNT));
--	  write(k,' ');
--	  write(k,TRI(PICOUNT));
--	  write(k,' ');
--	  write(k,TFI(PICOUNT));
--	  write(k,' ');
--	  write(k,PWI(PICOUNT));
--	  write(k,' ');
--	  write(k,PERI(PICOUNT));
--	  writeline(OUTPUT,k);
	end if;
      elsif NAME(1) = 'M' then 
      --| MOSFET Device: specify the four node numbers of MOSFET and 
      --| model name, channel length and width etc. 
        IDENTY := 'M'; 
        loop2k:
        for I in 2 to 8 loop
          read (k, NAME(I));
          exit loop2k when NAME(I) = ' '; 
        end loop loop2k;
        MCOUNT := MCOUNT + 1;
        read (k, NODE1);
        if RNUM < NODE1 then
          RNUM := NODE1;
        end if;
        ND(MCOUNT) := NODE1;  
        read (k, NODE1);
        if RNUM < NODE1 then
          RNUM := NODE1;
        end if;
        NG(MCOUNT) := NODE1;
        read (k, NODE1);
        if RNUM < NODE1 then
          RNUM := NODE1;
        end if;
        NS1(MCOUNT) := NODE1;
        read (k, NODE1);
        if RNUM < NODE1 then
          RNUM := NODE1;
        end if;
        NB(MCOUNT) := NODE1;
        loop3k:
        loop
          loop3kk3:
          for I in 1 to 8 loop
            CHAR(I) := ' ';
          end loop loop3kk3;
          read (k, CHAR(1));
          --|Skip the blank of character;
          if CHAR(1) /= ' ' then
            loop3kk1:
            for I in 2 to 8 loop
              read(k, CHAR(I));
              if CHAR(I) = ' ' then
                exit loop3kk1;
              elsif CHAR(I) = ';' then
                END_LINE := TRUE;
                exit loop3kk1;
              end if;
            end loop loop3kk1;
            exit loop3k;
          end if;
        end loop loop3k;
        MNAME(MCOUNT) := CHAR;
        loopty:
        for I in 1 to 8 loop
--          write(k, CHAR(I));
        end loop loopty;
       -- write(k, ND(MCOUNT));
       -- write(k, NG(MCOUNT));
       -- write(k, NS1(MCOUNT));
       -- write(k, NB(MCOUNT));
        if END_LINE = FALSE then 
          loop4k:
          loop
            loop4kk1:
            loop
              read(k, CHAR(1));
              exit loop4kk1 when CHAR(1) /= ' ';
            end loop loop4kk1;
            if CHAR(1) = 'L' or CHAR(1) = 'W' then
              loop4kk2:
              loop
                read(k, CHAR(2));
                if CHAR(2) = '=' then
                  read(k, VALUE);
                  read(k, CHAR(2));
                  exit loop4kk2;
                end if;
              end loop loop4kk2; 
              if CHAR(1) = 'L' then
                CHANNEL_L(MCOUNT) := 1.0e-6*VALUE;
       --         write(k, CHANNEL_L(MCOUNT));
              else
                CHANNEL_W(MCOUNT) := 1.0e-6*VALUE;
        --        write(k, CHANNEL_W(MCOUNT));
              end if;
            elsif CHAR(1) = 'A' or CHAR(1) = 'P' then
              read(k, CHAR(2));
              loop4kk3:
              loop
                read(k, CHAR(3));
                if CHAR(3) = '=' then
                  read(k, VALUE);
                  read(k, CHAR(3));
                  exit loop4kk3;
                end if;
              end loop loop4kk3; 
              if CHAR(1) = 'A' and CHAR(2) = 'D' then
                AD(MCOUNT) := 1.0e-12*VALUE;
         --       write(k, AD(MCOUNT));
              elsif CHAR(1) = 'A' and CHAR(2) = 'S' then
                AS(MCOUNT) := 1.0e-12*VALUE;
          --      write(k, AS(MCOUNT));
              elsif CHAR(1) = 'P' and CHAR(2) = 'D' then
                PD(MCOUNT) := 1.0e-6*VALUE;
           --     write(k, PD(MCOUNT));
              elsif CHAR(1) = 'P' and CHAR(2) = 'S' then
                PS(MCOUNT) := 1.0e-6*VALUE;
            --    write(k, PS(MCOUNT));
              end if;
            elsif CHAR(1) = 'N' then
              read(k, CHAR(1));  
              read(k, CHAR(2));  
              loop4kk4:
              loop
                read(k, CHAR(3));
                if CHAR(3) = '=' then
                  read(k, VALUE);
                  exit loop4kk4;
                end if;
              end loop loop4kk4; 
              if CHAR(2) = 'D' then
                NRD(MCOUNT) := VALUE;
             --   write(k, NRD(MCOUNT));
              else
                NRS(MCOUNT) := VALUE;
              --  write(k, NRS(MCOUNT));
              end if;
            elsif CHAR(1) = ';' then
              exit loop4k;
            end if;
          end loop loop4k;
         -- writeline(OUTPUT,k);
        end if;
      elsif NAME(1) = '+' and IDENTY = 'M' then
      --| Continue line of MOSFET Device;
        loop2l:
        loop
          loop2ll1:
          loop
            read(k, CHAR(1));
            exit loop2ll1 when CHAR(1) /= ' ';
          end loop loop2ll1;
          if CHAR(1) = 'L' or CHAR(1) = 'W' then
            loop2ll2:
            loop
              read(k, CHAR(2));
              if CHAR(2) = '=' then
                read(k, VALUE);
                exit loop2ll2;
              end if;
            end loop loop2ll2; 
            if CHAR(1) = 'L' then
              CHANNEL_L(MCOUNT) := 1.0e-6*VALUE;
            else
              CHANNEL_W(MCOUNT) := 1.0e-6*VALUE;
            end if;
          elsif CHAR(1) = 'A' or CHAR(1) = 'P' then
            read(k, CHAR(2));
            loop2ll3:
            loop
              read(k, CHAR(3));
              if CHAR(3) = '=' then
                read(k, VALUE);
                exit loop2ll3;
              end if;
            end loop loop2ll3; 
            if CHAR(1) = 'A' and CHAR(2) = 'D' then
              AD(MCOUNT) := 1.0e-12*VALUE;
            elsif CHAR(1) = 'A' and CHAR(2) = 'S' then
              AS(MCOUNT) := 1.0e-12*VALUE;
            elsif CHAR(1) = 'P' and CHAR(2) = 'D' then
              PD(MCOUNT) := 1.0e-6*VALUE;
            elsif CHAR(1) = 'P' and CHAR(2) = 'S' then
              PS(MCOUNT) := 1.0e-12*VALUE;
            end if;
          elsif CHAR(1) = 'N' then
            read(k, CHAR(1));  
            read(k, CHAR(2));  
            loop2ll4:
            loop
              read(k, CHAR(3));
              if CHAR(3) = '=' then
                read(k, VALUE);
                exit loop2ll4;
              end if;
            end loop loop2ll4;
            if CHAR(2) = 'D' then
              NRD(MCOUNT) := VALUE;
            else
              NRS(MCOUNT) := VALUE;
            end if;
          elsif CHAR(1) = ';' then
            exit loop2l;
          end if;
        end loop loop2l;
      elsif NAME(1) = '+' and IDENTY = 'T' then
      --| Continue line of .MODEL Card;
        loop2m:
        loop
          loop2mm1:
          loop
            read(k, CHAR(1));
            --|read characters untill parameter name is found and read the
            --|parameter value;
            if CHAR(1) /= ' ' and CHAR(1) /= ';' then
              loop3mm:
              for I in 2 to 8 loop
                read(k, CHAR(I));
                if CHAR(I) = '=' then
                  loop3mm1:
                  for J in I to 8 loop
                    CHAR(J) := ' ';
                  end loop loop3mm1;
                  exit loop3mm;
                end if; 
              end loop loop3mm;
              read(k, VALUE);
              exit loop2mm1;
            elsif CHAR(1) = ';' then
              exit loop2mm1;
            end if; 
          end loop loop2mm1;
          if CHAR(1) = 'V' and CHAR(2) = 'T' then
            MODEL_PARA(2, MODCOUNT) := VALUE;
            --write(k, "VTO ");
            --write(k, VALUE);
          elsif CHAR(1) = 'K' and CHAR(2) = 'P' then
            MODEL_PARA(3, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'G' then
            MODEL_PARA(4, MODCOUNT) := VALUE;       
            --write(k, VALUE);
          elsif CHAR(1) = 'P' and CHAR(2) = 'H' then
            MODEL_PARA(5, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'L' and CHAR(2) = 'A' then
            MODEL_PARA(6, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'R' and CHAR(2) = 'D' then
            MODEL_PARA(7, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'R' and CHAR(2) = 'S' and CHAR(3) = ' ' then
            MODEL_PARA(8, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'C' and CHAR(2) = 'B' and CHAR(3) = 'D' then
            MODEL_PARA(9, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'C' and CHAR(2) = 'B' and CHAR(3) = 'S' then
            MODEL_PARA(10, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'I' and CHAR(2) = 'S' then
            MODEL_PARA(11, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'P' and CHAR(2) = 'B' then
            MODEL_PARA(12, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'C' and CHAR(2) = 'G' and CHAR(3) = 'S' then
            MODEL_PARA(13, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'C' and CHAR(2) = 'G' and CHAR(3) = 'D' then
            MODEL_PARA(14, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'C' and CHAR(2) = 'G' and CHAR(3) = 'B' then
            MODEL_PARA(15, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'R' and CHAR(2) = 'S' and CHAR(3) = 'H' then
            MODEL_PARA(16, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'C' and CHAR(2) = 'J' and CHAR(3) = ' ' then
            MODEL_PARA(17, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'M' and CHAR(2) = 'J' and CHAR(3) = ' ' then
            MODEL_PARA(18, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'C' and CHAR(2) = 'J' and CHAR(3) = 'S' then
            MODEL_PARA(19, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'M' and CHAR(2) = 'J' and CHAR(3) = 'S' then
            MODEL_PARA(20, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'J' and CHAR(2) = 'S' then
            MODEL_PARA(21, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'T' and CHAR(2) = 'O' then
            MODEL_PARA(22, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'N' and CHAR(2) = 'S' and CHAR(3) = 'U' then
            MODEL_PARA(23, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'N' and CHAR(2) = 'S' and CHAR(3) = 'S' then
            MODEL_PARA(24, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'N' and CHAR(2) = 'F' and CHAR(3) = 'S' then
            MODEL_PARA(25, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'T' and CHAR(2) = 'P' then
            MODEL_PARA(26, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'X' and CHAR(2) = 'J' then
            MODEL_PARA(27, MODCOUNT) := 1.0e-6*VALUE;
          elsif CHAR(1) = 'L' and CHAR(2) = 'D' then
            MODEL_PARA(28, MODCOUNT) := 1.0e-6*VALUE;
          elsif CHAR(1) = 'U' and CHAR(2) = 'O' then
            MODEL_PARA(29, MODCOUNT) := 0.0001*VALUE;
          elsif CHAR(1) = 'U' and CHAR(2) = 'C' then
            MODEL_PARA(30, MODCOUNT) := 100.0*VALUE;
          elsif CHAR(1) = 'U' and CHAR(2) = 'E' then
            MODEL_PARA(31, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'U' and CHAR(2) = 'T' then
            MODEL_PARA(32, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'V' and CHAR(2) = 'M' then
            MODEL_PARA(33, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'N' and CHAR(2) = 'E' then
            MODEL_PARA(34, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'X' and CHAR(2) = 'Q' then
            MODEL_PARA(35, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'K' and CHAR(2) = 'F' then
            MODEL_PARA(36, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'A' and CHAR(2) = 'F' then
            MODEL_PARA(37, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'F' and CHAR(2) = 'C' then
            MODEL_PARA(38, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'D' and CHAR(2) = 'E' and CHAR(3) = 'L' then
            MODEL_PARA(39, MODCOUNT) := VALUE;
            --write(k, VALUE);
          elsif CHAR(1) = 'T' and CHAR(2) = 'H' then
            MODEL_PARA(40, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'E' and CHAR(2) = 'T' then
           MODEL_PARA(41, MODCOUNT) := VALUE;
          elsif CHAR(1) = 'K' and CHAR(2) = 'A' then
            MODEL_PARA(42, MODCOUNT) := VALUE;
          elsif CHAR(1) = ';' then
            exit loop2m;
          end if;
        end loop loop2m;
        --write(k,"line");
        --writeline(OUTPUT,k);
      elsif NAME(1) = '.' then
 	read (k, NAME(2));
	if NAME(2) = 'T' then
        --| .TRAN Card: transient analysis specification; 
	  loop2j:
	  for I in 3 to 8 loop
	    read (k, NAME(I));
	    exit loop2j when NAME(I) = ' ';
	  end loop loop2j;
	  read (k, TN);
	  STEP := TN;
	  read (k, TN);
	  CYCLETIME := TN;
	  --write(k,'.');
	  --write(k,'T');
	  --write(k,'R');
	  --write(k,'A');
	  --write(k,'N');
	  --write(k,' ');
	  --write(k,STEP);
	  --write(k,' ');
	  --write(k,CYCLETIME);
	  --writeline(OUTPUT,k);
        elsif NAME(2) = 'O' then
        --| .OPTIONS Card: user reset program control and user options 
        --| for specific simulation purpose;  
     	  loop3j:
	  for I in 3 to 8 loop
	    read(k, NAME(I));
	    exit loop3j when NAME(I) = ' ';
	  end loop loop3j;
	  read(k, CHAR(1));
	  --if CHAR(1) = 'R' then
	  --  loop4j:
	  --  for I in 2 to 8 loop
	  --    read(k, CHAR(I));
	  --    exit loop4j when CHAR(I) = '=';
	  --  end loop loop4j;
	  --  read(k, VALUE);
	  --  RELTOL := VALUE; 
          --elsif CHAR(1) = 'A' then
          --  loop4j0:
          --  for I in 2 to 8 loop
          --    read(k, CHAR(I));
          --    exit loop4j0 when CHAR(I) = '=';
          --  end loop loop4j0;
          --  read(k, VALUE);
          --  VNTOL := VALUE;
          if CHAR(1) = 'T' then
            loop4j1:
            for I in 2 to 8 loop
              read(k, CHAR(I));
              exit loop4j1 when CHAR(I) = '=';
            end loop loop4j1;
            read(k, VALUE);
            TNOM := VALUE;
	  end if;
	  --write(k,'R');
	  --write(k,'E');
	  --write(k,'L');
	  --write(k,'T');
	  --write(k,'O');
	  --write(k,'L');
	  --write(k,' ');
	  --write(k,RELTOL);
	  --writeline(OUTPUT,k);
        elsif NAME(2) = 'P' then
        --| PRINT Cards: specify the output variables to be printed;
          loop5j:
          for I in 3 to 8 loop
            read(k, NAME(I));
            exit loop5j when NAME(I) = ' ';
          end loop loop5j; 
          read(k,NAME(3));
          if NAME(3) = 'T' then
            loop1k:
            for I in 4 to 8 loop
              read(k, NAME(I));
              exit loop1k when NAME(I) = ' ';
            end loop loop1k;
            loop6j:
            loop
              read(k, CHAR(1));
              if CHAR(1)='V' or CHAR(1)='v' then
                read(k, CHAR(2));
                read(k, NODE1); 
                read(k, CHAR(3));
                VPRINC := VPRINC + 1;
                VPRIN(VPRINC) := NODE1;
                BLANK := 0;
              elsif CHAR(1) = 'I' then
                IPRINC := IPRINC + 1;
                read(k, CHAR(2));
                if CHAR(2) = '(' then
                  loop7j:
                  for I in 1 to 8 loop
                    read(k, NAME(I));
                    if NAME(I) = ')' then
                      loop7jj:
                      for J in I to 8 loop
                        NAME(J) := ' ';
                      end loop loop7jj;
                      exit loop7j;
                    end if;
                  end loop loop7j;
                  loop8j:
                  for I in 1 to VCOUNT loop
                    if VNAME(I) = NAME then
                      IPRIN1(IPRINC) := NV1(I);
                      IPRIN2(IPRINC) := NV2(I);
                      PNAME(IPRINC) := NAME;
                    end if;
                  end loop loop8j;
                  loop9j:
                  for I in 1 to PVCOUNT loop
                    if PVNAME(I) = NAME then
                      IPRIN1(IPRINC) := NVP1(I);
                      IPRIN2(IPRINC) := NVP2(I);
                      PNAME(IPRINC) := NAME;
                    end if;
                  end loop loop9j;
                else
                  C_PROCEDURE("printf", "wrong format of current output"); 
                end if; 
                BLANK := 0;
              elsif CHAR(1) = ' ' then
                BLANK := BLANK+1;
              end if;
              exit loop6j when BLANK > 1; 
            end loop loop6j; 
          end if;
        elsif NAME(2) = 'M' then
        --| .MODEL Card: specify transistor model parameters;
          IDENTY := 'T';
          MODCOUNT := MODCOUNT + 1;
          loop2n:
          for I in 1 to 8 loop
            read(k, CHAR(I));
            exit loop2n when CHAR(I) = ' ';
          end loop loop2n;
          --|read through the character of "MODEL";
          loop3n:
          loop
            loop3nn2:
            for I in 1 to 8 loop
              CHAR(I) := ' ';
            end loop loop3nn2;
            read(k, CHAR(1));
            --|find the character of model name;
            if CHAR(1) /= ' ' then
              loop3nn1:
              for I in 2 to 8 loop
              --|loop to finish reading the character of model name;
                read(k,CHAR(I));
                if CHAR(I) = ' ' then
                  exit loop3nn1;
                end if;
              end loop loop3nn1; 
              exit loop3n;
            end if;
          end loop loop3n;  
          MODEL_NAME(MODCOUNT) := CHAR;
          loop4n:
          loop
            loop4nn2:
            for I in 1 to 8 loop
              CHAR(I) := ' ';
            end loop loop4nn2;
            read(k, CHAR(1));
            if CHAR(1) /= ' ' then 
              loop4nn1:
              for I in 2 to 8 loop
                read(k,CHAR(I));
                if CHAR(I) = ' ' then
                  exit loop4nn1;
                end if;
              end loop loop4nn1;
              exit loop4n;
            end if;
          end loop loop4n;
          MODEL_TYPE(MODCOUNT) := CHAR;
          loopyy:
          for I in 1 to 8 loop
            --write(k, CHAR(I));
          end loop loopyy;
          loop5n:
          loop
            loop5nn1:
            loop
              read(k, CHAR(1));
              if CHAR(1) /= ' ' and CHAR(1) /= ';' then
                loop6nn:
                for I in 2 to 8 loop
                  read(k, CHAR(I));
                  if CHAR(I) = '=' then
                    loop6nn1:
                    for J in I to 8 loop
                      CHAR(J) := ' ';
                    end loop loop6nn1;
                    exit loop6nn;
                  end if;
                end loop loop6nn;
                read(k, VALUE);
                exit loop5nn1;
              elsif CHAR(1) = ';' then
                exit loop5nn1;
              end if;
            end loop loop5nn1;
            if CHAR(1)='L' and CHAR(2)= 'E' then
              MODEL_PARA(1, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'V' and CHAR(2) = 'T' then
              MODEL_PARA(2, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'K' and CHAR(2) = 'P' then
              MODEL_PARA(3, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'G' then
              MODEL_PARA(4, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'P' and CHAR(2) = 'H' then
              MODEL_PARA(5, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'L' and CHAR(2) = 'A' then
              MODEL_PARA(6, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'R' and CHAR(2) = 'D' then
              MODEL_PARA(7, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'R' and CHAR(2) = 'S' and CHAR(3) = ' ' then
              MODEL_PARA(8, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'C' and CHAR(2) = 'B' and CHAR(3) = 'D' then
              MODEL_PARA(9, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'C' and CHAR(2) = 'B' and CHAR(3) = 'S' then
              MODEL_PARA(10, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'I' and CHAR(2) = 'S' then
              MODEL_PARA(11, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'P' and CHAR(2) = 'B' then
              MODEL_PARA(12, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'C' and CHAR(2) = 'G' and CHAR(3) = 'S' then
              MODEL_PARA(13, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'C' and CHAR(2) = 'G' and CHAR(3) = 'D' then
              MODEL_PARA(14, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'C' and CHAR(2) = 'G' and CHAR(3) = 'B' then
              MODEL_PARA(15, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'R' and CHAR(2) = 'S' and CHAR(3) = 'H' then
              MODEL_PARA(16, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'C' and CHAR(2) = 'J' and CHAR(3) = ' ' then
              MODEL_PARA(17, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'M' and CHAR(2) = 'J' and CHAR(3) = ' ' then
              MODEL_PARA(18, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'C' and CHAR(2) = 'J' and CHAR(3) = 'S' then
              MODEL_PARA(19, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'M' and CHAR(2) = 'J' and CHAR(3) = 'S' then
              MODEL_PARA(20, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'J' and CHAR(2) = 'S' then
              MODEL_PARA(21, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'T' and CHAR(2) = 'O' then
              MODEL_PARA(22, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'N' and CHAR(2) = 'S' and CHAR(3) = 'U' then
              MODEL_PARA(23, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'N' and CHAR(2) = 'S' and CHAR(3) = 'S' then
              MODEL_PARA(24, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'N' and CHAR(2) = 'F' and CHAR(3) = 'S' then
              MODEL_PARA(25, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'T' and CHAR(2) = 'P' then
              MODEL_PARA(26, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'X' and CHAR(2) = 'J' then
              MODEL_PARA(27, MODCOUNT) := 1.0e-6*VALUE;
            elsif CHAR(1) = 'L' and CHAR(2) = 'D' then
              MODEL_PARA(28, MODCOUNT) := 1.0e-6*VALUE;
            elsif CHAR(1) = 'U' and CHAR(2) = 'O' then
              MODEL_PARA(29, MODCOUNT) := 0.0001*VALUE;
            elsif CHAR(1) = 'U' and CHAR(2) = 'C' then
              MODEL_PARA(30, MODCOUNT) := 100.0*VALUE;
            elsif CHAR(1) = 'U' and CHAR(2) = 'E' then
              MODEL_PARA(31, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'U' and CHAR(2) = 'T' then
              MODEL_PARA(32, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'V' and CHAR(2) = 'M' then
              MODEL_PARA(33, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'N' and CHAR(2) = 'E' then
              MODEL_PARA(34, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'X' and CHAR(2) = 'Q' then
              MODEL_PARA(35, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'K' and CHAR(2) = 'F' then
              MODEL_PARA(36, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'A' and CHAR(2) = 'F' then
              MODEL_PARA(37, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'F' and CHAR(2) = 'C' then
              MODEL_PARA(38, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'D' and CHAR(2) = 'E' and CHAR(3) = 'L' then
              MODEL_PARA(39, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'T' and CHAR(2) = 'H' then
              MODEL_PARA(40, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'E' and CHAR(2) = 'T' then
             MODEL_PARA(41, MODCOUNT) := VALUE;
            elsif CHAR(1) = 'K' and CHAR(2) = 'A' then
              MODEL_PARA(42, MODCOUNT) := VALUE;
            elsif CHAR(1) = ';' then
              exit loop5n;
            end if;
          end loop loop5n;
          --writeline(OUTPUT,k);
        end if;
      end if;
    end loop loop1;
  return;
  end READ_FILE;

--***********************************************************
--*                                                         *
--*   NODE_RENUMA                                           * BODY
--*                                                         *
--***********************************************************
--| purpose
--|
  procedure NODE_RENUMA
   (RNUM    : in INTEGER;
    VCOUNT  : in INTEGER;
    ICOUNT  : in INTEGER;
    PVCOUNT : in INTEGER;
    PICOUNT : in INTEGER;
    RCOUNT  : in INTEGER;
    CCOUNT  : in INTEGER;
    LCOUNT  : in INTEGER;
    MCOUNT  : in INTEGER;
    RNV1    : inout NODE_ARRAY;
    RNV2    : inout NODE_ARRAY;
    RNVP1   : inout NODE_ARRAY;
    RNVP2   : inout NODE_ARRAY;
    RNR1    : inout NODE_ARRAY;
    RNR2    : inout NODE_ARRAY;
    RNC1    : inout NODE_ARRAY;
    RNC2    : inout NODE_ARRAY;
    RNL1    : inout NODE_ARRAY;
    RNL2    : inout NODE_ARRAY;
    RND     : inout NODE_ARRAY;
    RNG     : inout NODE_ARRAY;
    RNS1    : inout NODE_ARRAY;
    RNB     : inout NODE_ARRAY;
    RNI1    : inout NODE_ARRAY;
    RNI2    : inout NODE_ARRAY;
    RNP1    : inout NODE_ARRAY;
    RNP2    : inout NODE_ARRAY)
  is
    file FILE2 : text is out "STD_OUTPUT";
    variable M : POSITIVE;
    variable I : POSITIVE;
    variable J : POSITIVE;
    variable K : POSITIVE;
    variable L : LINE;
  begin

    if VCOUNT > 0 then
      loop1:	
      for K in 1 to VCOUNT loop
        if RNV1(K) > 0 and RNV1(k) /= K then
          M := RNV1(K);
          loop2:
 	  for I in 1 to VCOUNT loop
 	    if RNV1(I) = K then
 	      RNV1(I) := M;
 	    elsif RNV2(I) = K then
 	      RNV2(I) := M;
 	    end if;
 	  end loop loop2;
	  RNV1(K) := K;
	  if RCOUNT /= 0 then 
 	    loop3:
 	    for J in 1 to RCOUNT loop
 	      if RNR1(J) = M then
	        RNR1(J) := K; 
 	      elsif RNR1(J) = K then
 	        RNR1(J) := M;
 	      end if;
	      if RNR2(J) = M then
 		RNR2(J) := K;
	      elsif RNR2(J) = K then
 		RNR2(J) := M;
	      end if;
	    end loop loop3;
	  end if;
	  if CCOUNT /= 0 then
 	    loop4:
 	    for J in 1 to CCOUNT loop
 	      if RNC1(J) = M then
	        RNC1(J) := K;
 	      elsif RNC1(J) = K then
 		RNC1(J) := M;
 	      end if;
 	      if RNC2(J) = M then
	        RNC2(J) := K;
 	      elsif RNC2(J) = K then
	        RNC2(J) := M;
	      end if;
	    end loop loop4;
	  end if;
	  if LCOUNT /= 0 then	
 	    loop5:
	    for J in 1 to LCOUNT loop
 	      if RNL1(J) = M then
 		RNL1(J) := K;
 	      elsif RNL1(J) = K then
 		RNL1(J) := M;
	      end if;
 	      if RNL2(J) = M then
 		RNL2(J) := K;
	      elsif RNL2(J) = K then
 		RNL2(J) := M;
	      end if;
	    end loop loop5;
	  end if;
	  if ICOUNT /= 0 then
	    loop6:
	    for J in 1 to ICOUNT loop
 	      if RNI1(J) = M then
 		RNI1(J) := K;
 	      elsif RNI1(J) = K then
	        RNI1(J) := M;
	      end if;
 	      if RNI2(j) = M then
 	  	RNI2(J) := K;
	      elsif RNI2(J) = K then
 		RNI2(J) := M;
	      end if;
	    end loop loop6;
	  end if;
	  if PICOUNT /= 0 then 
	    loop7:
 	    for J in 1 to PICOUNT loop
	      if RNP1(J) = M then
 		RNP1(J) := K;
	      elsif RNP1(J) = K then
 		RNP1(J) := M;
	      end if;
 	      if RNP2(J) = M then
 		RNP2(J) := K;
 	      elsif RNP2(J) = K then
 		RNP2(J) := M;
	      end if;
	    end loop loop7;
	  end if;
          if MCOUNT /= 0 then
            loop70:
            for J in 1 to MCOUNT loop
              if RND(J) = M then
                RND(J) := K;
              elsif RND(J) = K then
                RND(J) := M;
              end if;
              if RNG(J) = M then
                RNG(J) := K;
              elsif RNG(J) = K then
                RNG(J) := M;
              end if;
              if RNS1(J) = M then
                RNS1(J) := K;
              elsif RNS1(J) = K then
                RNS1(J) := M;
              end if;
              if RNB(J) = M then
                RNB(J) := K;
              elsif RNB(J) = K then
                RNB(J) := M;
              end if;
            end loop loop70;
          end if;
	  if PVCOUNT /= 0 then 
	    loop8:
 	    for J in 1 to PVCOUNT loop
 	      if RNVP1(J) = K then
 		RNVP1(J) := M;
              elsif RNVP2(J) = K then
                RNVP2(J) := M;
              end if;
	    end loop loop8; 
	  end if; 
        elsif RNV2(K) > 0 and RNV2(K) /= K then
 	  M := RNV2(k);
 	  loop2b:
	  for I in 1 to VCOUNT loop
 	    if RNV1(I) = K then
 	      RNV1(I) := M;
 	    elsif RNV2(I) = K then
 	      RNV2(I) := M;
 	    end if;
	  end loop loop2b;
 	  RNV2(K) := K;
	  if RCOUNT /= 0 then 
 	    loop3b:
 	    for J in 1 to RCOUNT loop
 	      if RNR1(J) = M then
 		RNR1(J) := K; 
	      elsif RNR1(J) = K then
 		RNR1(J) := M;
	      end if;
 	      if RNR2(J) = M then
 		RNR2(J) := K;
 	      elsif RNR2(J) = K then
 		RNR2(J) := M;
	      end if;
 	    end loop loop3b;
	  end if;
	  if CCOUNT /= 0 then
	    loop4b:
 	    for J in 1 to CCOUNT loop
 	      if RNC1(J) = M then
 	        RNC1(J) := K;
 	      elsif RNC1(J) = K then
 		RNC1(J) := M;
	      end if;
	      if RNC2(J) = M then
 		RNC2(J) := K;
	      elsif RNC2(J) = K then
	        RNC2(J) := M;
 	      end if;
	    end loop loop4b;
	  end if;
	  if LCOUNT /= 0 then
 	    loop5b:
 	    for J in 1 to LCOUNT loop
	      if RNL1(J) = M then
 		RNL1(J) := K;
	      elsif RNL1(J) = K then
 		RNL1(J) := M;
	      end if;
	      if RNL2(J) = M then
 		RNL2(J) := K;
 	      elsif RNL2(J) = K then
	        RNL2(J) := M;
	      end if;
	    end loop loop5b;
	  end if;
	  if ICOUNT /= 0 then	
	    loop6b:
 	    for J in 1 to ICOUNT loop
 	      if RNI1(J) = M then
		RNI1(J) := K;
 	      elsif RNI1(J) = K then
 		RNI1(J) := M;
 	      end if;
 	      if RNI2(J) = M then
	        RNI2(J) := K;
 	      elsif RNI2(J) = K then
	        RNI2(J) := M;
	      end if;
	    end loop loop6b;
	  end if;
	  if PICOUNT /= 0 then 
 	    loop7b:
 	    for J in 1 to PICOUNT loop
 	      if RNP1(J) = M then
	        RNP1(J) := K;
	      elsif RNP1(J) = K then
 		RNP1(J) := M;
	      end if;
	      if RNP2(J) = M then
 		RNP2(J) := K;
	      elsif RNP2(J) = K then
 		RNP2(J) := M;
	      end if;
	    end loop loop7b;
	  end if;
          if MCOUNT /= 0 then
            loop7b0:
            for J in 1 to MCOUNT loop
              if RND(J) = M then
                RND(J) := K;
              elsif RND(J) = K then
                RND(J) := M;
              end if;
              if RNG(J) = M then
                RNG(J) := K;
              elsif RNG(J) = K then
                RNG(J) := M;
              end if;
              if RNS1(J) = M then
                RNS1(J) := K;
              elsif RNS1(J) = K then
                RNS1(J) := M;
              end if;
              if RNB(J) = M then
                RNB(J) := K;
              elsif RNB(J) = K then
                RNB(J) := M;
              end if;
            end loop loop7b0;
          end if;
	  if PVCOUNT /= 0 then 
	    loop8b:
	    for J in 1 to PVCOUNT loop
	      if RNVP1(J) = K then
	        RNVP1(J) := M;
              elsif RNVP2(J)=k then
                RNVP2(J) := M;
              end if;
	    end loop loop8b;
	  end if;
	end if;
      end loop loop1;
    end if;

    if PVCOUNT /= 0 then
      loop1p:
      for K in 1 to PVCOUNT loop
 	if RNVP1(K) > 0  and RNVP1(K) /= K+VCOUNT then
	  M := RNVP1(K);
	  loop2p:
 	  for J in 1 to PVCOUNT loop
 	    if RNVP1(J) = K+VCOUNT then
 	      RNVP1(J) := M;
 	    elsif RNVP2(J) = K+VCOUNT then
 	      RNVP2(J) := M;
	    end if;
	  end loop loop2p;
	  RNVP1(K) := K+VCOUNT;
	  if RCOUNT /= 0 then 
 	    loop3p:
 	    for J in 1 to RCOUNT loop
	      if RNR1(J) = M then
 		RNR1(J) := K+VCOUNT; 
	      elsif RNR1(J) = K+VCOUNT then
 		RNR1(J) := M;
	      end if;
 	      if RNR2(J) = M then
 		RNR2(J) := K+VCOUNT;
	      elsif RNR2(J) = K+VCOUNT then
 		RNR2(J) := M;
 	      end if;
	    end loop loop3p;
	  end if;
  	if CCOUNT /= 0 then
  	  loop4p:
   	  for J in 1 to CCOUNT loop
   	    if RNC1(J) = M then
   	      RNC1(J) := K+VCOUNT;
   	    elsif RNC1(J) = K+VCOUNT then
  	      RNC1(J) := M;
  	    end if;
  	    if RNC2(J) = M then
  	      RNC2(J) := K+VCOUNT;
   	    elsif RNC2(J) = K+VCOUNT then
   	      RNC2(J) := M;
  	    end if;
   	  end loop loop4p;
  	end if;
  	if LCOUNT /= 0 then
       	  loop5p:
   	  for J in 1 to LCOUNT loop
   	    if RNL1(J) = M then
   	      RNL1(J) := K+VCOUNT;
   	    elsif RNL1(J) = K+VCOUNT then
  	      RNL1(J) := M;
  	    end if;
   	    if RNL2(J) = M then
   	      RNL2(J) := K+VCOUNT;
  	    elsif RNL2(J) = K+VCOUNT then
  	      RNL2(J) := M;
  	    end if;
  	  end loop loop5p;
  	end if;
  	if ICOUNT /= 0 then 
    	  loop6p:
            for J in 1 to ICOUNT loop
   	    if RNI1(J) = M then
  	      RNI1(J) := K+VCOUNT;
   	    elsif RNI1(J) = K+VCOUNT then
  	      RNI1(J) := M;
  	    end if;
  	    if RNI2(J) = M then
  	      RNI2(J) := K+VCOUNT;
  	    elsif RNI2(J) = K+VCOUNT then
  	      RNI2(J) := M;
   	    end if;
   	  end loop loop6p;
          end if;
          if PICOUNT /= 0 then 
  	  loop7p:
            for J in 1 to PICOUNT loop
   	    if RNP1(J) = M then
   	      RNP1(J) := K+VCOUNT;
   	    elsif RNP1(J) = K+VCOUNT then
   	      RNP1(J) := M;
  	    end if;
  	    if RNP2(J) = M then
  	      RNP2(J) := K+VCOUNT;
   	    elsif RNP2(J) = K+VCOUNT then
   	      RNP2(J) := M;
  	    end if;
  	  end loop loop7p;
  	end if;
          if MCOUNT /= 0 then
            loop7p0:
            for J in 1 to MCOUNT loop
              if RND(J) = M then
                RND(J) := K+VCOUNT;
              elsif RND(J) = K+VCOUNT then
                RND(J) := M;
              end if;
              if RNG(J) = M then
                RNG(J) := K+VCOUNT;
              elsif RNG(J) = K+VCOUNT then
                RNG(J) := M;
              end if;
              if RNS1(J) = M then
                RNS1(J) := K+VCOUNT;
              elsif RNS1(J) = K+VCOUNT then
                RNS1(J) := M;
              end if;
              if RNB(J) = M then
                RNB(J) := K+VCOUNT;
              elsif RNB(J) = K+VCOUNT then
                RNB(J) := M;
              end if;
            end loop loop7p0;
          end if;
        elsif RNVP2(K) > 0 and RNVP2(K) /= K+VCOUNT then
          M := RNVP2(K);
          loop2q:
          for J in 1 to PVCOUNT loop
   	  if RNVP1(J) = K+VCOUNT then
  	    RNVP1(J) := M;
   	  elsif RNVP2(J) = K+VCOUNT then
   	    RNVP2(J) := M;
  	  end if;
          end loop loop2q;
     	RNVP2(K) := K+VCOUNT;
  	if RCOUNT /= 0 then 
   	  loop3q:
   	  for J in 1 to RCOUNT loop
   	    if RNR1(J) = M then
  	      RNR1(J) := K+VCOUNT; 
   	    elsif RNR1(J) = K+VCOUNT then
  	      RNR1(J) := M;
  	    end if;
   	    if RNR2(J) = M then
   	      RNR2(J) := K+VCOUNT;
  	    elsif RNR2(J) = K+VCOUNT then
   	      RNR2(J) := M;
  	    end if;
  	  end loop loop3q;
          end if;
  	if CCOUNT /= 0 then
   	  loop4q:
     	  for J in 1 to CCOUNT loop
     	    if RNC1(J) = M then
    	      RNC1(J) := K+CCOUNT;
    	    elsif RNC1(J) = K+VCOUNT then
     	      RNC1(J) := M;
    	    end if;
    	    if RNC2(J) = M then
     	      RNC2(J) := K+VCOUNT;
     	    elsif RNC2(J) = K+VCOUNT then
     	      RNC2(J) := M;
    	    end if;
    	  end loop loop4q;
    	end if;
    	if LCOUNT /= 0 then
    	  loop5q:
     	  for J in 1 to LCOUNT loop
     	    if RNL1(J) = M then
     	      RNL1(J) := K+LCOUNT;
     	    elsif RNL1(J) = K+VCOUNT then
     	      RNL1(J) := M;
    	    end if;
    	    if RNL2(J) = M then
     	      RNL2(J) := K+VCOUNT;
     	    elsif RNL2(J) = K+VCOUNT then
     	      RNL2(J) := M;
    	    end if;
    	  end loop loop5q;
    	end if;
    	if ICOUNT /= 0 then
     	  loop6q:
    	  for J in 1 to ICOUNT loop
     	    if RNI1(J) = M then
    	      RNI1(J) := K+VCOUNT;
     	    elsif RNI1(J) = K+VCOUNT then
     	      RNI1(J) := M;
    	    end if;
     	    if RNI2(J) = M then
     	      RNI2(J) := K+VCOUNT;
     	    elsif RNI2(J) = K+VCOUNT Then
     	      RNI2(J) := M;
    	    end if;
    	  end loop loop6q;
    	end if;
    	if PICOUNT /= 0 then
    	  loop7q:
    	  for J in 1 to PICOUNT loop
    	    if RNP1(J) = M then
     	      RNP1(J) := K+VCOUNT;
     	    elsif RNP1(J) = K+VCOUNT then
     	      RNP1(J) := M;
    	    end if;
     	    if RNP2(J) = M then
     	      RNP2(J) := K+VCOUNT;
     	    elsif RNP2(J) = K+VCOUNT then
     	      RNP2(J) := M;
    	    end if;
    	  end loop loop7q;
    	end if;
          if MCOUNT /= 0 then
            loop7q0:
            for J in 1 to MCOUNT loop
              if RND(J) = M then
                RND(J) := K+VCOUNT;
              elsif RND(J) = K+VCOUNT then
                RND(J) := M;
              end if;
              if RNG(J) = M then
                RNG(J) := K+VCOUNT;
              elsif RNG(J) = K+VCOUNT then
                RNG(J) := M;
              end if;
              if RNS1(J) = M then
                RNS1(J) := K+VCOUNT;
              elsif RNS1(J) = K+VCOUNT then
                RNS1(J) := M;
              end if;
              if RNB(J) = M then
                RNB(J) := K+VCOUNT;
              elsif RNB(J) = K+VCOUNT then
                RNB(J) := M;
              end if;
            end loop loop7q0;
          end if;
        end if;
      end loop loop1p;
    end if;
  return;	
  end NODE_RENUMA;
  
  --***********************************************************
  --*                                                         *
  --*   NODE_RENUMB                                           * BODY
  --*                                                         *
  --***********************************************************
    procedure NODE_RENUMB
     (VCOUNT  : in INTEGER;
      ICOUNT  : in INTEGER;
      PVCOUNT : in INTEGER;
      PICOUNT : in INTEGER;
      RCOUNT  : in INTEGER;
      CCOUNT  : in INTEGER;
      LCOUNT  : in INTEGER;
      MCOUNT  : in INTEGER;
      NRNUM   : inout INTEGER; 
      RNV1    : inout NODE_ARRAY;
      RNV2    : inout NODE_ARRAY;
      RNVP1   : inout NODE_ARRAY;
      RNVP2   : inout NODE_ARRAY;
      RNR1    : inout NODE_ARRAY;
      RNR2    : inout NODE_ARRAY;
      RNC1    : inout NODE_ARRAY;
      RNC2    : inout NODE_ARRAY;
      RNL1    : inout NODE_ARRAY;
      RNL2    : inout NODE_ARRAY;
      RNI1    : inout NODE_ARRAY;
      RNI2    : inout NODE_ARRAY;
      RNP1    : inout NODE_ARRAY;
      RNP2    : inout NODE_ARRAY;
      RND     : inout NODE_ARRAY;
      RNG     : inout NODE_ARRAY;
      RNS1    : inout NODE_ARRAY;
      RNB     : inout NODE_ARRAY)
    is
      variable I : INTEGER := 0;
      variable k : INTEGER := 0;
      variable M : INTEGER := 0;
    begin
  
      loops1:
      for k in 1 to LCOUNT loop
        if RNL1(k) < RNL2(k) then
          M := RNL2(k);
          RNL2(k) := RNL1(k);
          NRNUM := NRNUM - 1;
          loopR1:
          for I in 1 to RCOUNT loop
            if RNR1(I) = M then
              RNR1(I) := RNL1(k);
            elsif RNR1(I) > M then
              RNR1(I) := RNR1(I) - 1;
            end if;
            if RNR2(I) = M then
              RNR2(I) := RNL1(k);
      	    elsif RNR2(I) > M then
              RNR2(I) := RNR2(I) - 1;
            end if;
          end loop loopR1;
          loopL1:
  	  for I in 1 to LCOUNT loop
    	    if RNL1(I) = M then
              RNL1(I) := RNL1(k);
            elsif RNL1(I) > M then
              RNL1(I) := RNL1(I) - 1;
            end if;
            if RNL2(I) = M then
              RNL2(I) := RNL1(k);
            elsif RNL2(I) > M then
              RNL2(I) := RNL2(I) - 1;
            end if;
  	  end loop loopL1;
  	  if ICOUNT /= 0 then
      	  loopI1:
      	  for I in 1 to ICOUNT loop
            if RNI1(I) = M then
              RNI1(I) := RNL1(k);
            elsif RNI1(I) > M then
              RNI1(I) := RNI1(I) - 1;
       	    end if;
       	      if RNI2(I) = M then
                RNI2(I) := RNL1(k);
              elsif RNI2(I) > M then
                RNI2(I) := RNI2(I) - 1;
              end if;
       	    end loop loopI1;
  	  end if;
  	if PICOUNT /= 0 then
  	  loopI2:
  	  for I in 1 to PICOUNT loop
    	    if RNP1(I) = M then
    	      RNP1(I) := RNL1(k);
    	    elsif RNP1(I) > M then
     	      RNP1(I) := RNP1(I) - 1;
    	    end if;
    	    if RNP2(I) = M then
     	      RNP2(I) := RNL1(k);
              elsif RNP2(I) > M then
     	      RNP2(I) := RNP2(I) - 1;
    	    end if;
  	  end loop loopI2;
  	end if;
        if MCOUNT /= 0 then
          loopI20:
          for I in 1 to MCOUNT loop
            if RND(I) = M then
              RND(I) := RNL1(k);
            elsif RND(I) > M then
              RND(I) := RND(I) - 1;
            end if;
            if RNG(I) = M then
              RNG(I) := RNL1(k);
            elsif RNG(I) > M then
              RNG(I) := RNG(I) - 1;
            end if;
            if RNS1(I) = M then
              RNS1(I) := RNL1(k);
            elsif RNS1(I) > M then
              RNS1(I) := RNS1(I) - 1;
            end if;
            if RNB(I) = M then
              RNB(I) := RNL1(k);
            elsif RNB(I) > M then
              RNB(I) := RNB(I) - 1;
            end if;
          end loop loopI20;
        end if;
        elsif RNL1(k) > RNL2(k) then
    	M := RNL1(k);
          loopR2:
          for I in 1 to RCOUNT loop
            if RNR1(I) = M then
              RNR1(I) := RNL2(k);
      	  elsif RNR1(I) > M then
              RNR1(I) := RNR1(I) - 1;
      	  end if;
            if RNR2(I) = M then
              RNR2(I) := RNL2(k);
            elsif RNR2(I) > M then
              RNR2(I) := RNR2(I) - 1;
            end if;
          end loop loopR2;
          loopL2:
  	for I in 1 to LCOUNT loop
    	  if RNL1(I) = M then
    	    RNL1(I) := RNL2(k);
    	  elsif RNL1(I) > M then
     	    RNL1(I) := RNL1(I) - 1;
    	  end if;
    	  if RNL2(I) = M then
     	    RNL2(I) := RNL2(k);
    	  elsif RNL2(I) > M then
     	    RNL2(I) := RNL2(I) - 1;
    	  end if;
  	end loop loopL2;
          if ICOUNT > 0 then
            loopI3:
            for I in 1 to ICOUNT loop
              if RNI1(I) = M then
                RNI1(I) := RNL2(k);
              elsif RNI1(I) > M then
                RNI1(I) := RNI1(I) - 1;
              end if;
              if RNI2(I) = M then
                RNI2(I) := RNL2(k);
              elsif RNI2(I) > M then
                RNI2(I) := RNI2(I) - 1;
              end if;
            end loop loopI3;
          end if;
          if PICOUNT > 0 then
            loopI4:
            for I in 1 to PICOUNT loop
              if RNP1(I) = M then
                RNP1(I) := RNL2(k);
              elsif RNP1(I) > M then
                RNP1(I) := RNP1(I) - 1;
              end if;
              if RNP2(I) = M then
                RNP2(I) := RNL2(k);
              elsif RNP2(I) > M then
                RNP2(I) := RNP2(I) - 1;
              end if;
            end loop loopI4;
          end if;
        if MCOUNT /= 0 then
          loopI30:
          for I in 1 to MCOUNT loop
            if RND(I) = M then
              RND(I) := RNL1(k);
            elsif RND(I) > M then
              RND(I) := RND(I) - 1;
            end if;
            if RNG(I) = M then
              RNG(I) := RNL1(k);
            elsif RNG(I) > M then
              RNG(I) := RNG(I) - 1;
            end if;
            if RNS1(I) = M then
              RNS1(I) := RNL1(k);
            elsif RNS1(I) > M then
              RNS1(I) := RNS1(I) - 1;
            end if;
            if RNB(I) = M then
              RNB(I) := RNL1(k);
            elsif RNB(I) > M then
              RNB(I) := RNB(I) - 1;
            end if;
          end loop loopI30;
        end if;
          RNL1(k) := RNL2(k);
          NRNUM := NRNUM - 1;
        end if;
      end loop loops1;
  return;
  end NODE_RENUMB;
  
  --*****************************************************************
  --*
  --*   NODE_BACKNUMDC
  --*
  --*****************************************************************
    procedure NODE_BACKNUMDC
     (RNR1    : in NODE_ARRAY;
      RNR2    : in NODE_ARRAY;
      NR1     : in NODE_ARRAY;
      NR2     : in NODE_ARRAY;
      RCOUNT  : in INTEGER;
      VOP     : in VALUE_ARRAY;
      V       : inout VALUE_ARRAY)
    is
      variable k  : INTEGER := 0;
    begin
  
      loop1:
      for k in 1 to RCOUNT loop
        if NR1(k) /= RNR1(k) and RNR1(k) /= 0 then
          V(NR1(k)) := VOP(RNR1(k));
        elsif NR1(k) /= RNR1(k) and RNR1(k) = 0 then
          V(NR1(k)) := 0.000000;
        end if;
        if NR2(k) /= RNR2(k) and RNR2(k) /= 0 then
          V(NR2(k)) := VOP(RNR2(k));
        elsif NR2(k)/= RNR2(k) and RNR2(k) = 0 then 
          V(NR2(k)) := 0.000000;
        end if;
      end loop loop1;
      return;
    end NODE_BACKNUMDC;
  
  --*******************************************************************
  --*                                                                 *
  --*   NODE_BACKNUMTR                                                *
  --*                                                                 *
  --*******************************************************************
    procedure NODE_BACKNUMTR
     (RNR1    : in NODE_ARRAY;
      RNR2    : in NODE_ARRAY;
      NR1     : in NODE_ARRAY;
      NR2     : in NODE_ARRAY;
      RCOUNT  : in INTEGER;
      RND     : in NODE_ARRAY;
      RNG     : in NODE_ARRAY;
      RNS1    : in NODE_ARRAY;
      RNB     : in NODE_ARRAY;
      ND      : in NODE_ARRAY;
      NG      : in NODE_ARRAY;
      NS1     : in NODE_ARRAY;
      NB      : in NODE_ARRAY;
      MCOUNT  : in INTEGER;
      I       : inout VALUE_ARRAY;
      V       : inout VALUE_ARRAY)
    is 
      variable VT : VALUE_ARRAY(1 to V'HIGH);  
      variable IT : VALUE_ARRAY(1 to I'HIGH); 
      variable k  : INTEGER := 0;
    begin
  
      IT := I;
      VT := V;
      if RCOUNT /= 0 then
        loop1:
        for k in 1 to RCOUNT loop
          if NR1(k) /= RNR1(k) then
            V(NR1(k)) := VT(RNR1(k));
            I(NR1(k)) := IT(RNR1(k));
          end if;
          if NR2(k) /= RNR2(k) then
            V(NR2(k)) := VT(RNR2(k));
            I(NR2(k)) := IT(RNR2(k));
          end if;
        end loop loop1;
      else 
        loop2:
        for k in 1 to MCOUNT loop
          if ND(k) /= RND(k) then
            V(ND(k)) := VT(RND(k));
            I(ND(k)) := IT(RND(k));
          end if;
          if NG(k) /= RNG(k) then
            V(NG(k)) := VT(RNG(k));
            I(NG(k)) := IT(RNG(k));
          end if;
          if NS1(k) /= RNS1(k) then
            V(NS1(k)) := VT(RNS1(k));
            I(NS1(k)) := IT(RNS1(k));
          end if;
          if NB(k) /= RNB(k) then
            V(NB(k)) := VT(RNB(k));
            I(NB(k)) := IT(RNB(k));
          end if;
        end loop loop2;
      end if;
    return;
    end NODE_BACKNUMTR;
  
  --***********************************************************
  --*                                                         *
  --*   OUTPUT_FORMATDC                                       * BODY 
  --*                                                         *
  --***********************************************************
    procedure OUTPUT_FORMATDC
     (VDC    : in VALUE_ARRAY;
      IDC    : in VALUE_ARRAY;
      PNAME  : in NAME_ARRAY;
      IPRIN1 : in NODE_ARRAY;
      IPRIN2 : in NODE_ARRAY;
      IPRINC : in INTEGER;
      RNUM   : in INTEGER)
    is
      file FILE2    : TEXT is out "STD_OUTPUT";
      variable Ic   : REAL;
      variable NAME : ELEMENT_NAME;
      variable k    : LINE;
      variable I    : INTEGER := 0;
      variable J    : INTEGER := 0;
    begin
        loop1:
        for I in 1 to RNUM loop
        end loop loop1;
      if IPRINC /= 0 then
        loop2:
        for I in 1 to IPRINC loop
          write(k, "I(");
          NAME := PNAME(I);
          loop3:
          for J in 1 to 8 loop
            if NAME(J) /= ' ' then
              write(k, NAME(J));
            end if;
          end loop loop3;
          write(k, ')');
          if IPRIN1(I) /= 0 then
            write(k, IDC(IPRIN1(I)));
          elsif IPRIN2(I) /= 0 then            
            Ic := - IDC(IPRIN2(I));
            write(k, Ic);
          end if;      
          write(k, ' ');
        end loop loop2; 	
        writeline(OUTPUT, k);
      end if;
    return;
    end OUTPUT_FORMATDC;

--***********************************************************
--*                                                         *
--*   OUTPUT_FORMATTR                                       * BODY 
--*                                                         *
--***********************************************************
  procedure OUTPUT_FORMATTR
   (V      : in VALUE_ARRAY;
    I      : in VALUE_ARRAY;
    T      : in TIME;
    VPRIN  : in NODE_ARRAY;
    PNAME  : in NAME_ARRAY;
    IPRIN1 : in NODE_ARRAY;
    IPRIN2 : in NODE_ARRAY;
    VPRINC : in INTEGER;
    IPRINC : in INTEGER)
  is
    file FILE2 : TEXT is out "STD_OUTPUT";
    variable Ic: REAL;
    variable k : LINE;
    variable NAME : ELEMENT_NAME;
    variable J : INTEGER := 0;
    variable L : INTEGER := 0;
  begin 
    
    if VPRINC /= 0 then
      loop1:
      for J in 1 to VPRINC loop
      end loop loop1;
    end if;
    if IPRINC /= 0 then
      loop2:
      for J in 1 to IPRINC loop
        NAME := PNAME(J);
        loop3:
        for L in 1 to 8 loop
          if NAME(L) /= ' ' then
          end if;
        end loop loop3;
        if IPRIN1(J) /= 0 then 
        elsif IPRIN2(J) /= 0 then
          Ic := - I(IPRIN2(J));
        end if;
      end loop loop2;
    end if;
  return;
  end OUTPUT_FORMATTR; 

end IO_PACK;
