//
// Copyright (c) 1997-2001 UCR. Permission to copy is granted
// provided that this header remains intact. This software is
// provided with no warranties.
//

//----------------------------------------------------------------------------

#ifndef bussim_h
#define bussim_h

//----------------------------------------------------------------------------

enum Encoding { Binary, Gray, Invert };

//----------------------------------------------------------------------------

struct BusState {
    
    unsigned width;
    Encoding encoding;
    
    unsigned long packets;
    unsigned long mask;
    unsigned long state;
    bool invert;
};

//----------------------------------------------------------------------------

class BusSimulator {
    
public:
    unsigned long addrBitToggles;
    unsigned long dataBitToggles;
    
public:
    BusState addrState;
    BusState dataState;
    double voltage;
    
public:
    BusSimulator();
    ~BusSimulator();
    
public:
    void Reset(unsigned aw, Encoding ae, unsigned dw, Encoding de, double _voltage);
    
public:
    double ComputePower();
    
public:
    void Transfer(unsigned long a);
    
private:
    unsigned long TransferBinary(unsigned long v, BusState &bs);
    unsigned long TransferGray(unsigned long v, BusState &bs);
    unsigned long TransferInvert(unsigned long v, BusState &bs);
    
private:
    unsigned long HamDist(unsigned long v1, unsigned long v2, unsigned width);
};

//----------------------------------------------------------------------------

#endif