/******* PowerStone Benchmark *******/

#include "platune.h"

/*
* Fixed parameters for both transmit and receive.
*/
#define N1  11  /* maximum codeword size in bits (V.42bis App II.1) */
#define N2  (1<<N1) /* maximum number of codewords */
#define N3  8   /* character size in bits */
#define N4  (1<<N3) /* number of characters in alphabet */
#define N5  (N4+N6) /* index of first dict entry to use for strings
*    0..N6-1 are reserved for control codewords,
*    N6..N5-1 are reserved for individual chars. */
#define N6  3   /* number of control codewords */
#define N7  250 /* maximum string length */

/*
* Control codewords (compress mode only)
*/
#define ETM 0   /* Enter transparent mode */
#define FLUSH   1   /* Flush data */
#define STEPUP  2   /* Step up codeword size */

/*
* Command codes (transparent mode only, i.e. escape code, command code)
*/
#define ECM 0   /* Enter compress mode */
#define EID 1   /* Escape character in data */
#define RESET   2   /* Force reinitialization */

/*
* Control function codes (passed as out-of-band values).
*/
#define C_INIT      (-1)
#define C_ERROR     (-2)
#define C_DATA      (-3)
#define C_TRANSFER  (-4)
#define C_FLUSH     (-5)
#define C_STOP      (-6)    /* not part of V42 spec */


/*
* Variable parameters common to transmit and receive.
*/
int p0;     /* enable compression (negotiated) */
int p1;     /* number of codewords (negotiated) */
int p2;     /* maximum string size (negotiated) */


            /*
            * Variable parameters separate for transmit and receive.
*/
int c1;     /* next empty dict entry */
int c2;     /* current codeword size */
int c3;     /* threshold for codeword size change */
int escape;     /* current escape character */
int compress;   /* compression mode */


                /*
                * Dictionaries for transmit encoding and receive decoding.
*/
struct  dict
{
    unsigned int    parent:11;
    unsigned int    kids:11;
    unsigned int    sibling:11;
    unsigned int    data:8;
};
struct  dict    dict[N2+1];     /* sentinel on end */
unsigned long   last;


/****************************************************************
* Internal source and buffers
****************************************************************/
unsigned char inbuf[] = {
/* yes, this is really ugly, but ANSI says strings shouldn't exceed 509
    chars, so this way the code is more portable. - david */
    '%','!','P','S','-','A','d','o','b','e','-','2','.','0','\n',
        '%','%','C','r','e','a','t','o','r',':',' ','d','v','i','p','s','k',' ','5','.','5','8','a',' ','C','o','p','y','r','i','g','h','t',' ','1','9','8','6',',',' ','1','9','9','4',' ','R','a','d','i','c','a','l',' ','E','y','e',' ','S','o','f','t','w','a','r','e','\n',
        '%','%','T','i','t','l','e',':',' ','s','e','s','t','e','m','p','l','a','t','e','.','d','v','i','\n',
        '%','%','P','a','g','e','s',':',' ','1','\n',
        '%','%','P','a','g','e','O','r','d','e','r',':',' ','A','s','c','e','n','d','\n',
        '%','%','B','o','u','n','d','i','n','g','B','o','x',':',' ','0',' ','0',' ','6','1','2',' ','7','9','2','\n',
        '%','%','D','o','c','u','m','e','n','t','F','o','n','t','s',':',' ','T','i','m','e','s','-','B','o','l','d',' ','T','i','m','e','s','-','R','o','m','a','n',' ','T','i','m','e','s','-','B','o','l','d','I','t','a','l','i','c',' ','T','i','m','e','s','-','I','t','a','l','i','c','\n',
        '%','%','D','o','c','u','m','e','n','t','P','a','p','e','r','S','i','z','e','s',':',' ','L','e','t','t','e','r','\n',
        '%','%','E','n','d','C','o','m','m','e','n','t','s','\n',
        '%','D','V','I','P','S','C','o','m','m','a','n','d','L','i','n','e',':',' ','d','v','i','p','s',' ','s','e','s','t','e','m','p','l','a','t','e','.','d','v','i','\n',
        '%','D','V','I','P','S','P','a','r','a','m','e','t','e','r','s',':',' ','d','p','i','=','3','0','0',',',' ','c','o','m','p','r','e','s','s','e','d',',',' ','c','o','m','m','e','n','t','s',' ','r','e','m','o','v','e','d','\n',
        '%','D','V','I','P','S','S','o','u','r','c','e',':',' ',' ','T','e','X',' ','o','u','t','p','u','t',' ','1','9','9','6','.','0','1','.','2','5',':','2','2','0','4','\n',
        '%','%','B','e','g','i','n','P','r','o','c','S','e','t',':',' ','t','e','x','c','.','p','r','o','\n',
        '/','T','e','X','D','i','c','t',' ','2','5','0',' ','d','i','c','t',' ','d','e','f',' ','T','e','X','D','i','c','t',' ','b','e','g','i','n',' ','/','N','{','d','e','f','}','d','e','f',' ','/','B','{','b','i','n','d',' ','d','e','f','}','N',' ','/','S','{','e','x','c','h','}','N','\n',
        '/','X','{','S',' ','N','}','B',' ','/','T','R','{','t','r','a','n','s','l','a','t','e','}','N',' ','/','i','s','l','s',' ','f','a','l','s','e',' ','N',' ','/','v','s','i','z','e',' ','1','1',' ','7','2',' ','m','u','l',' ','N',' ','/','h','s','i','z','e',' ','8','.','5',' ','7','2','\n',
        'm','u','l',' ','N',' ','/','l','a','n','d','p','l','u','s','9','0','{','f','a','l','s','e','}','d','e','f',' ','/','@','r','i','g','i','n','{','i','s','l','s','{','[','0',' ','l','a','n','d','p','l','u','s','9','0','{','1',' ','-','1','}','{','-','1',' ','1','}','\n',
        'i','f','e','l','s','e',' ','0',' ','0',' ','0',']','c','o','n','c','a','t','}','i','f',' ','7','2',' ','R','e','s','o','l','u','t','i','o','n',' ','d','i','v',' ','7','2',' ','V','R','e','s','o','l','u','t','i','o','n',' ','d','i','v',' ','n','e','g',' ','s','c','a','l','e','\n',
        'i','s','l','s','{','l','a','n','d','p','l','u','s','9','0','{','V','R','e','s','o','l','u','t','i','o','n',' ','7','2',' ','d','i','v',' ','v','s','i','z','e',' ','m','u','l',' ','0',' ','e','x','c','h','}','{','R','e','s','o','l','u','t','i','o','n',' ','-','7','2',' ','d','i','v','\n',
        'h','s','i','z','e',' ','m','u','l',' ','0','}','i','f','e','l','s','e',' ','T','R','}','i','f',' ','R','e','s','o','l','u','t','i','o','n',' ','V','R','e','s','o','l','u','t','i','o','n',' ','v','s','i','z','e',' ','-','7','2',' ','d','i','v',' ','1',' ','a','d','d',' ','m','u','l','\n',
        'T','R','[','m','a','t','r','i','x',' ','c','u','r','r','e','n','t','m','a','t','r','i','x','{','d','u','p',' ','d','u','p',' ','r','o','u','n','d',' ','s','u','b',' ','a','b','s',' ','0','.','0','0','0','0','1',' ','l','t','{','r','o','u','n','d','}','i','f','}','\n',
        'f','o','r','a','l','l',' ','r','o','u','n','d',' ','e','x','c','h',' ','r','o','u','n','d',' ','e','x','c','h',']','s','e','t','m','a','t','r','i','x','}','N',' ','/','@','l','a','n','d','s','c','a','p','e','{','/','i','s','l','s',' ','t','r','u','e',' ','N','}','B','\n',
        '/','@','m','a','n','u','a','l','f','e','e','d','{','s','t','a','t','u','s','d','i','c','t',' ','/','m','a','n','u','a','l','f','e','e','d',' ','t','r','u','e',' ','p','u','t','}','B',' ','/','@','c','o','p','i','e','s','{','/','#','c','o','p','i','e','s',' ','X','}','B','\n',
        '/','F','M','a','t','[','1',' ','0',' ','0',' ','-','1',' ','0',' ','0',']','N',' ','/','F','B','B','[','0',' ','0',' ','0',' ','0',']','N',' ','/','n','n',' ','0',' ','N',' ','/','I','E',' ','0',' ','N',' ','/','c','t','r',' ','0',' ','N',' ','/','d','f','-','t','a','i','l','{','\n',
        '/','n','n',' ','8',' ','d','i','c','t',' ','N',' ','n','n',' ','b','e','g','i','n',' ','/','F','o','n','t','T','y','p','e',' ','3',' ','N',' ','/','F','o','n','t','M','a','t','r','i','x',' ','f','n','t','r','x',' ','N',' ','/','F','o','n','t','B','B','o','x',' ','F','B','B',' ','N','\n',
        's','t','r','i','n','g',' ','/','b','a','s','e',' ','X',' ','a','r','r','a','y',' ','/','B','i','t','M','a','p','s',' ','X',' ','/','B','u','i','l','d','C','h','a','r','{','C','h','a','r','B','u','i','l','d','e','r','}','N',' ','/','E','n','c','o','d','i','n','g',' ','I','E',' ','N','\n',
        'e','n','d',' ','d','u','p','{','/','f','o','o',' ','s','e','t','f','o','n','t','}','2',' ','a','r','r','a','y',' ','c','o','p','y',' ','c','v','x',' ','N',' ','l','o','a','d',' ','0',' ','n','n',' ','p','u','t',' ','/','c','t','r',' ','0',' ','N','[','}','B',' ','/','d','f','{','\n',
        '/','s','f',' ','1',' ','N',' ','/','f','n','t','r','x',' ','F','M','a','t',' ','N',' ','d','f','-','t','a','i','l','}','B',' ','/','d','f','s','{','d','i','v',' ','/','s','f',' ','X',' ','/','f','n','t','r','x','[','s','f',' ','0',' ','0',' ','s','f',' ','n','e','g',' ','0',' ','0',']','\n',
        'N',' ','d','f','-','t','a','i','l','}','B',' ','/','E','{','p','o','p',' ','n','n',' ','d','u','p',' ','d','e','f','i','n','e','f','o','n','t',' ','s','e','t','f','o','n','t','}','B',' ','/','c','h','-','w','i','d','t','h','{','c','h','-','d','a','t','a',' ','d','u','p','\n',
        'l','e','n','g','t','h',' ','5',' ','s','u','b',' ','g','e','t','}','B',' ','/','c','h','-','h','e','i','g','h','t','{','c','h','-','d','a','t','a',' ','d','u','p',' ','l','e','n','g','t','h',' ','4',' ','s','u','b',' ','g','e','t','}','B',' ','/','c','h','-','x','o','f','f','{','\n',
        '1','2','8',' ','c','h','-','d','a','t','a',' ','d','u','p',' ','l','e','n','g','t','h',' ','3',' ','s','u','b',' ','g','e','t',' ','s','u','b','}','B',' ','/','c','h','-','y','o','f','f','{','c','h','-','d','a','t','a',' ','d','u','p',' ','l','e','n','g','t','h',' ','2',' ','s','u','b','\n',
        'g','e','t',' ','1','2','7',' ','s','u','b','}','B',' ','/','c','h','-','d','x','{','c','h','-','d','a','t','a',' ','d','u','p',' ','l','e','n','g','t','h',' ','1',' ','s','u','b',' ','g','e','t','}','B',' ','/','c','h','-','i','m','a','g','e','{','c','h','-','d','a','t','a','\n',
        'd','u','p',' ','t','y','p','e',' ','/','s','t','r','i','n','g','t','y','p','e',' ','n','e','{','c','t','r',' ','g','e','t',' ','/','c','t','r',' ','c','t','r',' ','1',' ','a','d','d',' ','N','}','i','f','}','B',' ','/','i','d',' ','0',' ','N',' ','/','r','w',' ','0',' ','N','\n',
        '/','r','c',' ','0',' ','N',' ','/','g','p',' ','0',' ','N',' ','/','c','p',' ','0',' ','N',' ','/','G',' ','0',' ','N',' ','/','s','f',' ','0',' ','N',' ','/','C','h','a','r','B','u','i','l','d','e','r','{','s','a','v','e',' ','3',' ','1',' ','r','o','l','l',' ','S',' ','d','u','p','\n',
        '/','b','a','s','e',' ','g','e','t',' ','2',' ','i','n','d','e','x',' ','g','e','t',' ','S',' ','/','B','i','t','M','a','p','s',' ','g','e','t',' ','S',' ','g','e','t',' ','/','c','h','-','d','a','t','a',' ','X',' ','p','o','p',' ','/','c','t','r',' ','0',' ','N',' ','c','h','-','d','x','\n',
        '0',' ','c','h','-','x','o','f','f',' ','c','h','-','y','o','f','f',' ','c','h','-','h','e','i','g','h','t',' ','s','u','b',' ','c','h','-','x','o','f','f',' ','c','h','-','w','i','d','t','h',' ','a','d','d',' ','c','h','-','y','o','f','f','\n',
        's','e','t','c','a','c','h','e','d','e','v','i','c','e',' ','c','h','-','w','i','d','t','h',' ','c','h','-','h','e','i','g','h','t',' ','t','r','u','e','[','1',' ','0',' ','0',' ','-','1',' ','-','.','1',' ','c','h','-','x','o','f','f',' ','s','u','b',' ','c','h','-','y','o','f','f','\n',
        '.','1',' ','s','u','b',']','/','i','d',' ','c','h','-','i','m','a','g','e',' ','N',' ','/','r','w',' ','c','h','-','w','i','d','t','h',' ','7',' ','a','d','d',' ','8',' ','i','d','i','v',' ','s','t','r','i','n','g',' ','N',' ','/','r','c',' ','0',' ','N',' ','/','g','p',' ','0',' ','N','\n',
        '/','c','p',' ','0',' ','N','{','r','c',' ','0',' ','n','e','{','r','c',' ','1',' ','s','u','b',' ','/','r','c',' ','X',' ','r','w','}','{','G','}','i','f','e','l','s','e','}','i','m','a','g','e','m','a','s','k',' ','r','e','s','t','o','r','e','}','B',' ','/','G','{','{','i','d','\n',
        'g','p',' ','g','e','t',' ','/','g','p',' ','g','p',' ','1',' ','a','d','d',' ','N',' ','d','u','p',' ','1','8',' ','m','o','d',' ','S',' ','1','8',' ','i','d','i','v',' ','p','l',' ','S',' ','g','e','t',' ','e','x','e','c','}','l','o','o','p','}','B',' ','/','a','d','v','{','c','p','\n',
        'a','d','d',' ','/','c','p',' ','X','}','B',' ','/','c','h','g','{','r','w',' ','c','p',' ','i','d',' ','g','p',' ','4',' ','i','n','d','e','x',' ','g','e','t','i','n','t','e','r','v','a','l',' ','p','u','t','i','n','t','e','r','v','a','l',' ','d','u','p',' ','g','p',' ','a','d','d','\n',
        '/','g','p',' ','X',' ','a','d','v','}','B',' ','/','n','d','{','/','c','p',' ','0',' ','N',' ','r','w',' ','e','x','i','t','}','B',' ','/','l','s','h','{','r','w',' ','c','p',' ','2',' ','c','o','p','y',' ','g','e','t',' ','d','u','p',' ','0',' ','e','q','{','p','o','p',' ','1','}','{','\n',
        'd','u','p',' ','2','5','5',' ','e','q','{','p','o','p',' ','2','5','4','}','{','d','u','p',' ','d','u','p',' ','a','d','d',' ','2','5','5',' ','a','n','d',' ','S',' ','1',' ','a','n','d',' ','o','r','}','i','f','e','l','s','e','}','i','f','e','l','s','e',' ','p','u','t',' ','1','\n',
        'a','d','v','}','B',' ','/','r','s','h','{','r','w',' ','c','p',' ','2',' ','c','o','p','y',' ','g','e','t',' ','d','u','p',' ','0',' ','e','q','{','p','o','p',' ','1','2','8','}','{','d','u','p',' ','2','5','5',' ','e','q','{','p','o','p',' ','1','2','7','}','{','d','u','p',' ','2','\n',
        'i','d','i','v',' ','S',' ','1','2','8',' ','a','n','d',' ','o','r','}','i','f','e','l','s','e','}','i','f','e','l','s','e',' ','p','u','t',' ','1',' ','a','d','v','}','B',' ','/','c','l','r','{','r','w',' ','c','p',' ','2',' ','i','n','d','e','x',' ','s','t','r','i','n','g','\n',
        'p','u','t','i','n','t','e','r','v','a','l',' ','a','d','v','}','B',' ','/','s','e','t','{','r','w',' ','c','p',' ','f','i','l','l','s','t','r',' ','0',' ','4',' ','i','n','d','e','x',' ','g','e','t','i','n','t','e','r','v','a','l',' ','p','u','t','i','n','t','e','r','v','a','l','\n',
        'a','d','v','}','B',' ','/','f','i','l','l','s','t','r',' ','1','8',' ','s','t','r','i','n','g',' ','0',' ','1',' ','1','7','{','2',' ','c','o','p','y',' ','2','5','5',' ','p','u','t',' ','p','o','p','}','f','o','r',' ','N',' ','/','p','l','[','{','a','d','v',' ','1',' ','c','h','g','}','\n',
        '{','a','d','v',' ','1',' ','c','h','g',' ','n','d','}','{','1',' ','a','d','d',' ','c','h','g','}','{','1',' ','a','d','d',' ','c','h','g',' ','n','d','}','{','a','d','v',' ','l','s','h','}','{','a','d','v',' ','l','s','h',' ','n','d','}','{','a','d','v',' ','r','s','h','}','{','\n',
        'a','d','v',' ','r','s','h',' ','n','d','}','{','1',' ','a','d','d',' ','a','d','v','}','{','/','r','c',' ','X',' ','n','d','}','{','1',' ','a','d','d',' ','s','e','t','}','{','1',' ','a','d','d',' ','c','l','r','}','{','a','d','v',' ','2',' ','c','h','g','}','{','a','d','v',' ','2','\n',
        'c','h','g',' ','n','d','}','{','p','o','p',' ','n','d','}',']','d','u','p','{','b','i','n','d',' ','p','o','p','}','f','o','r','a','l','l',' ','N',' ','/','D','{','/','c','c',' ','X',' ','d','u','p',' ','t','y','p','e',' ','/','s','t','r','i','n','g','t','y','p','e',' ','n','e','{',']','\n',
        '}','i','f',' ','n','n',' ','/','b','a','s','e',' ','g','e','t',' ','c','c',' ','c','t','r',' ','p','u','t',' ','n','n',' ','/','B','i','t','M','a','p','s',' ','g','e','t',' ','S',' ','c','t','r',' ','S',' ','s','f',' ','1',' ','n','e','{','d','u','p',' ','d','u','p','\n',
        'l','e','n','g','t','h',' ','1',' ','s','u','b',' ','d','u','p',' ','2',' ','i','n','d','e','x',' ','S',' ','g','e','t',' ','s','f',' ','d','i','v',' ','p','u','t','}','i','f',' ','p','u','t',' ','/','c','t','r',' ','c','t','r',' ','1',' ','a','d','d',' ','N','}','B',' ','/','I','{','\n',
        'c','c',' ','1',' ','a','d','d',' ','D','}','B',' ','/','b','o','p','{','u','s','e','r','d','i','c','t',' ','/','b','o','p','-','h','o','o','k',' ','k','n','o','w','n','{','b','o','p','-','h','o','o','k','}','i','f',' ','/','S','I',' ','s','a','v','e',' ','N',' ','@','r','i','g','i','n','\n',
        '0',' ','0',' ','m','o','v','e','t','o',' ','/','V',' ','m','a','t','r','i','x',' ','c','u','r','r','e','n','t','m','a','t','r','i','x',' ','d','u','p',' ','1',' ','g','e','t',' ','d','u','p',' ','m','u','l',' ','e','x','c','h',' ','0',' ','g','e','t',' ','d','u','p',' ','m','u','l','\n',
        'a','d','d',' ','.','9','9',' ','l','t','{','/','Q','V','}','{','/','R','V','}','i','f','e','l','s','e',' ','l','o','a','d',' ','d','e','f',' ','p','o','p',' ','p','o','p','}','N',' ','/','e','o','p','{','S','I',' ','r','e','s','t','o','r','e',' ','u','s','e','r','d','i','c','t','\n',
        '/','e','o','p','-','h','o','o','k',' ','k','n','o','w','n','{','e','o','p','-','h','o','o','k','}','i','f',' ','s','h','o','w','p','a','g','e','}','N',' ','/','@','s','t','a','r','t','{','u','s','e','r','d','i','c','t',' ','/','s','t','a','r','t','-','h','o','o','k','\n',
        'k','n','o','w','n','{','s','t','a','r','t','-','h','o','o','k','}','i','f',' ','p','o','p',' ','/','V','R','e','s','o','l','u','t','i','o','n',' ','X',' ','/','R','e','s','o','l','u','t','i','o','n',' ','X',' ','1','0','0','0',' ','d','i','v',' ','/','D','V','I','m','a','g',' ','X','\n',
        '/','I','E',' ','2','5','6',' ','a','r','r','a','y',' ','N',' ','0',' ','1',' ','2','5','5','{','I','E',' ','S',' ','1',' ','s','t','r','i','n','g',' ','d','u','p',' ','0',' ','3',' ','i','n','d','e','x',' ','p','u','t',' ','c','v','n',' ','p','u','t','}','f','o','r','\n',
        '6','5','7','8','1','.','7','6',' ','d','i','v',' ','/','v','s','i','z','e',' ','X',' ','6','5','7','8','1','.','7','6',' ','d','i','v',' ','/','h','s','i','z','e',' ','X','}','N',' ','/','p','{','s','h','o','w','}','N',' ','/','R','M','a','t','[','1',' ','0',' ','0',' ','-','1',' ','0','\n',
        '0',']','N',' ','/','B','D','o','t',' ','2','6','0',' ','s','t','r','i','n','g',' ','N',' ','/','r','u','l','e','x',' ','0',' ','N',' ','/','r','u','l','e','y',' ','0',' ','N',' ','/','v','{','/','r','u','l','e','y',' ','X',' ','/','r','u','l','e','x',' ','X',' ','V','}','B',' ','/','V','\n',
        '{','}','B',' ','/','R','V',' ','s','t','a','t','u','s','d','i','c','t',' ','b','e','g','i','n',' ','/','p','r','o','d','u','c','t',' ','w','h','e','r','e','{','p','o','p',' ','p','r','o','d','u','c','t',' ','d','u','p',' ','l','e','n','g','t','h',' ','7',' ','g','e','{','0',' ','7','\n',
        'g','e','t','i','n','t','e','r','v','a','l',' ','d','u','p','(','D','i','s','p','l','a','y',')','e','q',' ','e','x','c','h',' ','0',' ','4',' ','g','e','t','i','n','t','e','r','v','a','l','(','N','e','X','T',')','e','q',' ','o','r','}','{','p','o','p',' ','f','a','l','s','e','}','\n',
        'i','f','e','l','s','e','}','{','f','a','l','s','e','}','i','f','e','l','s','e',' ','e','n','d','{','{','g','s','a','v','e',' ','T','R',' ','-','.','1',' ','.','1',' ','T','R',' ','1',' ','1',' ','s','c','a','l','e',' ','r','u','l','e','x',' ','r','u','l','e','y',' ','f','a','l','s','e','\n',
        'R','M','a','t','{','B','D','o','t','}','i','m','a','g','e','m','a','s','k',' ','g','r','e','s','t','o','r','e','}','}','{','{','g','s','a','v','e',' ','T','R',' ','-','.','1',' ','.','1',' ','T','R',' ','r','u','l','e','x',' ','r','u','l','e','y',' ','s','c','a','l','e',' ','1',' ','1','\n',
        'f','a','l','s','e',' ','R','M','a','t','{','B','D','o','t','}','i','m','a','g','e','m','a','s','k',' ','g','r','e','s','t','o','r','e','}','}','i','f','e','l','s','e',' ','B',' ','/','Q','V','{','g','s','a','v','e',' ','n','e','w','p','a','t','h',' ','t','r','a','n','s','f','o','r','m','\n',
        'r','o','u','n','d',' ','e','x','c','h',' ','r','o','u','n','d',' ','e','x','c','h',' ','i','t','r','a','n','s','f','o','r','m',' ','m','o','v','e','t','o',' ','r','u','l','e','x',' ','0',' ','r','l','i','n','e','t','o',' ','0',' ','r','u','l','e','y',' ','n','e','g','\n',
        'r','l','i','n','e','t','o',' ','r','u','l','e','x',' ','n','e','g',' ','0',' ','r','l','i','n','e','t','o',' ','f','i','l','l',' ','g','r','e','s','t','o','r','e','}','B',' ','/','a','{','m','o','v','e','t','o','}','B',' ','/','d','e','l','t','a',' ','0',' ','N',' ','/','t','a','i','l','\n',
        '{','d','u','p',' ','/','d','e','l','t','a',' ','X',' ','0',' ','r','m','o','v','e','t','o','}','B',' ','/','M','{','S',' ','p',' ','d','e','l','t','a',' ','a','d','d',' ','t','a','i','l','}','B',' ','/','b','{','S',' ','p',' ','t','a','i','l','}','B',' ','/','c','{','-','4',' ','M','}','\n',
        'B',' ','/','d','{','-','3',' ','M','}','B',' ','/','e','{','-','2',' ','M','}','B',' ','/','f','{','-','1',' ','M','}','B',' ','/','g','{','0',' ','M','}','B',' ','/','h','{','1',' ','M','}','B',' ','/','i','{','2',' ','M','}','B',' ','/','j','{','3',' ','M','}','B',' ','/','k','{','\n',
        '4',' ','M','}','B',' ','/','w','{','0',' ','r','m','o','v','e','t','o','}','B',' ','/','l','{','p',' ','-','4',' ','w','}','B',' ','/','m','{','p',' ','-','3',' ','w','}','B',' ','/','n','{','p',' ','-','2',' ','w','}','B',' ','/','o','{','p',' ','-','1',' ','w','}','B',' ','/','q','{','\n',
        'p',' ','1',' ','w','}','B',' ','/','r','{','p',' ','2',' ','w','}','B',' ','/','s','{','p',' ','3',' ','w','}','B',' ','/','t','{','p',' ','4',' ','w','}','B',' ','/','x','{','0',' ','S',' ','r','m','o','v','e','t','o','}','B',' ','/','y','{','3',' ','2',' ','r','o','l','l',' ','p','\n',
        'a','}','B',' ','/','b','o','s','{','/','S','S',' ','s','a','v','e',' ','N','}','B',' ','/','e','o','s','{','S','S',' ','r','e','s','t','o','r','e','}','B',' ','e','n','d','\n',
        '%','%','E','n','d','P','r','o','c','S','e','t','\n',
        '%','%','B','e','g','i','n','P','r','o','c','S','e','t',':',' ','t','e','x','p','s','.','p','r','o','\n',
        'T','e','X','D','i','c','t',' ','b','e','g','i','n',' ','/','r','f','{','f','i','n','d','f','o','n','t',' ','d','u','p',' ','l','e','n','g','t','h',' ','1',' ','a','d','d',' ','d','i','c','t',' ','b','e','g','i','n','{','1',' ','i','n','d','e','x',' ','/','F','I','D',' ','n','e',' ','2','\n',
        'i','n','d','e','x',' ','/','U','n','i','q','u','e','I','D',' ','n','e',' ','a','n','d','{','d','e','f','}','{','p','o','p',' ','p','o','p','}','i','f','e','l','s','e','}','f','o','r','a','l','l','[','1',' ','i','n','d','e','x',' ','0',' ','6',' ','-','1',' ','r','o','l','l','\n',
        'e','x','e','c',' ','0',' ','e','x','c','h',' ','5',' ','-','1',' ','r','o','l','l',' ','V','R','e','s','o','l','u','t','i','o','n',' ','R','e','s','o','l','u','t','i','o','n',' ','d','i','v',' ','m','u','l',' ','n','e','g',' ','0',' ','0',']','/','M','e','t','r','i','c','s','\n',
        'e','x','c','h',' ','d','e','f',' ','d','i','c','t',' ','b','e','g','i','n',' ','E','n','c','o','d','i','n','g','{','e','x','c','h',' ','d','u','p',' ','t','y','p','e',' ','/','i','n','t','e','g','e','r','t','y','p','e',' ','n','e','{','p','o','p',' ','p','o','p',' ','1',' ','s','u','b','\n',
        'd','u','p',' ','0',' ','l','e','{','p','o','p','}','{','[','}','i','f','e','l','s','e','}','{','F','o','n','t','M','a','t','r','i','x',' ','0',' ','g','e','t',' ','d','i','v',' ','M','e','t','r','i','c','s',' ','0',' ','g','e','t',' ','d','i','v',' ','d','e','f','}','\n',
        'i','f','e','l','s','e','}','f','o','r','a','l','l',' ','M','e','t','r','i','c','s',' ','/','M','e','t','r','i','c','s',' ','c','u','r','r','e','n','t','d','i','c','t',' ','e','n','d',' ','d','e','f','[','2',' ','i','n','d','e','x',' ','c','u','r','r','e','n','t','d','i','c','t','\n',
        'e','n','d',' ','d','e','f','i','n','e','f','o','n','t',' ','3',' ','-','1',' ','r','o','l','l',' ','m','a','k','e','f','o','n','t',' ','/','s','e','t','f','o','n','t',' ','l','o','a','d',']','c','v','x',' ','d','e','f','}','d','e','f','\n',
        '/','O','b','l','i','q','u','e','S','l','a','n','t','{','d','u','p',' ','s','i','n',' ','S',' ','c','o','s',' ','d','i','v',' ','n','e','g','}','B',' ','/','S','l','a','n','t','F','o','n','t','{','4',' ','i','n','d','e','x',' ','m','u','l',' ','a','d','d','}','d','e','f','\n',
        '/','E','x','t','e','n','d','F','o','n','t','{','3',' ','-','1',' ','r','o','l','l',' ','m','u','l',' ','e','x','c','h','}','d','e','f',' ','/','R','e','E','n','c','o','d','e','F','o','n','t','{','/','E','n','c','o','d','i','n','g',' ','e','x','c','h',' ','d','e','f','}','d','e','f','\n',
        'e','n','d','\n',
        '%','%','E','n','d','P','r','o','c','S','e','t','\n',
        'T','e','X','D','i','c','t',' ','b','e','g','i','n',' ','4','0','2','5','8','4','3','1',' ','5','2','0','9','9','1','4','6',' ','1','0','0','0',' ','3','0','0',' ','3','0','0',' ','(','s','e','s','t','e','m','p','l','a','t','e','.','d','v','i',')','\n',
        '@','s','t','a','r','t',' ','/','F','a',' ','1','3','9','[','9',' ','1','3',' ','3','[','1','7',' ','1','7',' ','4','[','9',' ','1','7',' ','1','[','1','1',' ','1','5',' ','3','[','1','5',' ','1','2','[','2','0','\n',
        '3','7','[','8',' ','4','6','[','{','}','1','1',' ','3','3','.','3','3','3','3','3','4',' ','/','T','i','m','e','s','-','R','o','m','a','n',' ','r','f',' ','/','F','b',' ','1',' ','5','0',' ','d','f','<','1','2','1','8','1','2','7','8','1','2','9','8','1','2','1','8','A','C','1','2','\n',
        'F','F','0','8','1','0','7','D','8','F','0','F','>','4','9',' ','D',' ','E',' ','/','F','c',' ','1',' ','1','6',' ','d','f','<','E','A','0','3','C','0','E','A','0','F','F','0','E','A','1','F','F','8','E','A','3','F','F','C','E','A','7','F','F','E','A','2','B','5','F','C','A','4','E','A','\n',
        '7','F','F','E','A','2','E','A','3','F','F','C','E','A','1','F','F','8','E','A','0','F','F','0','E','A','0','3','C','0','1','0','1','0','7','E','9','1','1','5','>','1','5',' ','D',' ','E',' ','/','F','d',' ','1','\n',
        '5','0',' ','d','f','<','1','2','0','C','1','2','1','C','1','2','E','C','1','2','0','C','A','F','E','A','F','F','C','0','0','A','1','3','7','D','9','2','1','1','>','4','9',' ','D',' ','E',' ','/','F','e',' ','8','1','[','2','3','\n',
        '5','2','[','2','1',' ','1','[','3','0',' ','2','1',' ','2','1',' ','1','2',' ','1','6',' ','1','4',' ','2','1',' ','2','1',' ','2','1',' ','2','1',' ','3','2',' ','1','2',' ','2','1',' ','1','[','1','2',' ','2','1','\n',
        '2','1',' ','1','4',' ','1','8',' ','2','1',' ','1','8',' ','2','1',' ','1','8',' ','3','[','1','4',' ','1','[','1','4',' ','6','[','2','5',' ','1','[','2','8',' ','8','[','1','4',' ','3','[','2','5',' ','1','7','[','2','1','\n',
        '1','[','2','1',' ','2','[','1','0',' ','1','[','1','0',' ','2','[','1','4',' ','1','4',' ','4','0','[','{','}','3','6',' ','4','1','.','6','6','6','6','6','9',' ','/','T','i','m','e','s','-','R','o','m','a','n','\n',
        'r','f',' ','/','F','f',' ','1','3','5','[','1','8',' ','3','[','1','2',' ','1','6',' ','1','6',' ','1','[','2','1',' ','2','1',' ','2','1',' ','3','0',' ','1','2',' ','2','[','1','2',' ','2','1',' ','2','1','\n',
        '1','2',' ','1','8',' ','1','[','1','8',' ','2','1',' ','2','1',' ','1','2','[','2','3',' ','5','[','2','8',' ','2','6','[','2','1',' ','4','[','1','0',' ','4','6','[','{','}','2','1',' ','4','1','.','6','6','6','6','6','9','\n',
        '/','T','i','m','e','s','-','I','t','a','l','i','c',' ','r','f',' ','/','F','g',' ','1','7','1','[','2','5',' ','2','3',' ','2','8',' ','1','4','[','2','8',' ','2','8',' ','2','8',' ','6','5','[','{','}','6','\n',
        '4','1','.','6','6','6','6','6','9',' ','/','T','i','m','e','s','-','B','o','l','d','I','t','a','l','i','c',' ','r','f',' ','/','F','h',' ','1','3','4','[','2','5',' ','3','[','2','5',' ','1','4',' ','1','9','\n',
        '1','7',' ','1','[','2','5',' ','2','5',' ','2','5',' ','3','9',' ','1','4',' ','2','[','1','4',' ','2','5',' ','2','[','2','2',' ','2','5',' ','2','2',' ','1','[','2','2',' ','6','[','3','0',' ','6','[','2','8','\n',
        '2','[','2','8',' ','1','[','3','6',' ','4','4',' ','3','[','1','7',' ','1','[','3','6',' ','1','[','3','0',' ','3','6',' ','3','3',' ','1','[','3','6',' ','1','7','[','1','4',' ','2','[','1','2',' ','4','4','[','{','}','2','9','\n',
        '5','0','.','0','0','0','0','0','1',' ','/','T','i','m','e','s','-','R','o','m','a','n',' ','r','f',' ','/','F','i',' ','1','3','4','[','3','0',' ','3','[','3','3',' ','2','0',' ','2','3',' ','2','7',' ','1','[','3','3','\n',
        '3','0',' ','3','3',' ','5','0',' ','1','7',' ','2','[','1','7',' ','2','[','2','0',' ','2','7',' ','3','3',' ','2','7',' ','1','[','3','0',' ','1','2','[','4','0',' ','3','3',' ','4','3',' ','1','[','3','7','\n',
        '6','[','2','3',' ','3','[','4','0',' ','2','[','4','0',' ','1','4','[','3','0',' ','3','0',' ','3','0',' ','4','9','[','{','}','2','6',' ','5','9','.','9','9','9','9','7','4',' ','/','T','i','m','e','s','-','B','o','l','d','\n',
        'r','f',' ','e','n','d','\n',
        '%','%','E','n','d','P','r','o','l','o','g','\n',
        '%','%','B','e','g','i','n','S','e','t','u','p','\n',
        '%','%','F','e','a','t','u','r','e',':',' ','*','R','e','s','o','l','u','t','i','o','n',' ','3','0','0','d','p','i','\n',
        'T','e','X','D','i','c','t',' ','b','e','g','i','n','\n',
        '%','%','P','a','p','e','r','S','i','z','e',':',' ','L','e','t','t','e','r','\n',
        '%','%','B','e','g','i','n','P','a','p','e','r','S','i','z','e',':',' ','L','e','t','t','e','r','\n',
        'l','e','t','t','e','r','\n',
        '%','%','E','n','d','P','a','p','e','r','S','i','z','e','\n',
        '\n',
        '%','%','E','n','d','S','e','t','u','p','\n',
        '%','%','P','a','g','e',':',' ','1',' ','1','\n',
        '1',' ','0',' ','b','o','p',' ','7','8','7',' ','1','7','4',' ','a',' ','F','i','(','S','E','S',')','1','5',' ','b','(','P','a','p','e','r',')','f','(','T',')','-','5',' ','b','(','e','m','p','l','a','t','e',')','9','1','4','\n',
        '2','9','5',' ','y',' ','F','h','(','A','u','t','h','o','r',')','1','1',' ','b','(','N','a','m','e',')','9','3','2',' ','4','1','1',' ','y','(','D','e','p','a','r','t','m','e','n','t',')','8','1','7',' ','4','6','9','\n',
        'y','(','M','o','t','o','r','o','l','a',')','h','(','G','r','o','u','p','/','S','e','c','t','o','r',')','9','0','3',' ','5','2','7',' ','y','(','C','i','t','y',')','m','(',',',')','g','(','S','t','a','t','e',')','g','(','Z','I','P',')','9','0','3','\n',
        '5','8','5',' ','y','(','E','m','a','i','l',')','g','(','A','d','d','r','e','s','s',')','4','0','8',' ','7','4','8',' ','y',' ','F','g','(','A','B','S','T','R','A','C','T',')','0',' ','8','3','9',' ','y',' ','F','f','(','T','h','e',')','h','(','t','e','x','t',')','g','(','o','f',')','\n',
        'f','(','t','h','e',')','h','(','a','b','s','t','r','a','c','t',')','f','(','g','o','e','s',')','h','(','h','e','r',')','n','(','e','.',')','2','3',' ','b','(','N','o',')','1','3',' ','b','(','m','o','r',')','n','(','e',')','g','(','t','h','a','n',')','f','(','3',')','h','\n',
        '(','i','n','c','h','e','s',')','g','(','o','f',')','0',' ','8','8','9',' ','y','(','a','b','s','t','r','a','c','t',')','c','(','t','e','x','t',')','i','(','p','l','e','a','s','e','.',')','0',' ','1','0','2','9','\n',
        'y',' ','F','i','(','1',')','6','0',' ','b','(','I','n','t','r',')','o','(','o','d','u','c','t','i','o','n',')','0',' ','1','1','4','6',' ','y','(','2',')','g','(','B','o','d','y',')','1','4',' ','b','(','S','e','c','t','i','o','n','s',')','0','\n',
        '1','2','3','9',' ','y',' ','F','e','(','T','h','i','s',')','d','(','i','s',')','f','(','a',')','i','(','b','o','d','y',')','e','(','p','a','r','a','g','r','a','p','h','.',')','1','6',' ','b','(','I','t',')','1','0','\n',
        'b','(','i','s',')','h','(','n','o','t',')','f','(','v','e','r','y',')','h','(','l','o','n','g',',',')','f','(','b','u','t',')','g','(','l','o','n','g',')','g','(','e','n','o','u','g','h',')','0',' ','1','2','8','9','\n',
        'y','(','t','o',')','g','(','m','a','k','e',')','h','(','i','t',')','e','(','\\','2','5','6','t',')','h','(','o','n',')','g','(','m','u','l','t','i','p','l','e',')','f','(','l','i','n','e','s','.',')','1','2','5','\n',
        '1','3','3','9',' ','y','(','T','h','i','s',')','g','(','i','s',')','h','(','a','n','o','t','h','e','r',')','f','(','b','o','d','y',')','g','(','p','a','r','a','g','r','a','h','.',')','1','5',' ','b','(','I','t',')','9','\n',
        'b','(','i','s',')','g','(','m','u','c','h',')','i','(','l','o','n','g','e','r',')','e','(','\\','\\','(','w','e','l','l',',',')','0',' ','1','3','8','8',' ','y','(','a',')','j','(','l','i','t','t','l','e',')','d','(','l','o','n','g','e','r',')','i','(','a','t',')','g','\n',
        '(','l','e','a','s','t','\\','\\',')',',',')','h','(','a','n','d',')','f','(','i','t',')','f','(','r','e','q','u','i','r','e','s',')','h','(','a','t',')','h','(','l','e','a','s','t',')','f','(','3',')','g','(','l','i','n','e','s',')','g','(','t','o',')','g','(','\\','2','5','6','t',')','g','\n',
        '(','t','h','e',')','0',' ','1','4','3','8',' ','y','(','c','o','n','t','e','n','t',')','f','(','o','f',')','g','(','i','t','.',')','2','1','2',' ','1','4','2','3',' ','y',' ','F','d','(','1',')','4','2',' ','1','5','2','1','\n',
        'y',' ','F','c','(','\\','0','1','7',')','2','0',' ','b',' ','F','e','(','T','h','i','s',')','1','0',' ','b','(','i','s',')','g','(','a',')','h','(','b','u','l','l','e','t','.',')','0',' ','1','6','6','1',' ','y','\n',
        'F','i','(','3',')','6','0',' ','b','(','R','e','f','e','r',')','o','(','e','n','c','e','s',')','2','1',' ','1','7','5','4',' ','y',' ','F','e','(','[','1',']','\\','\\',')',')','9',' ','b','(','R','e','f','e','r','e','n','c','e','s',')','j','(','i','n',')','e','(','I','E','E','E',')','h','\n',
        '(','s','t','a','n','d','a','r','d',')','f','(','f','o','r','m','a','t','.',')','p',' ','0',' ','2','5','1','1',' ','4','1','2',' ','2',' ','v',' ','4','2',' ','2','5','3','8',' ','a',' ','F','b','(','1',')','6','0','\n',
        '2','5','5','0',' ','y',' ','F','a','(','T','h','i','s',')','e','(','i','s',')','h','(','a',')','f','(','f','o','o','t','n','o','t','e','.',')','p',' ','e','o','p','\n',
        '%','%','T','r','a','i','l','e','r','\n',
        'e','n','d','\n',
        'u','s','e','r','d','i','c','t',' ','/','e','n','d','-','h','o','o','k',' ','k','n','o','w','n','{','e','n','d','-','h','o','o','k','}','i','f','\n',
        '%','%','E','O','F','\0'
};

unsigned long   baddr, eaddr;
int     codedone;

unsigned char   codebuf[8*1024];
unsigned char   outbuf[8*1024];
unsigned char   *eout = outbuf;

static  unsigned char   *gP, *gE;

/****************************************************************
*
****************************************************************/
int getdata()
{
    if (gP >= gE)
    {   if (!gE)
    {   gP = inbuf;
    gE = inbuf + sizeof(inbuf);
    return (C_INIT);
    }
    if (gP > gE)
        return (C_STOP);
    gP++;
    return (C_FLUSH);
    } 
    return (*gP++);
}

/****************************************************************
*
****************************************************************/
int getcode(int size)
{
    unsigned char   *p;
    unsigned long   code;
    
    if (size == 0)
    {   baddr = (baddr + 7) & ~7;
    return (0);
    }
    
    if (codedone)
    {   if (codedone < 0)
    return (C_STOP);
    codedone = 0;
    return (C_INIT);
    }
    
    if (baddr >= eaddr)
    {   codedone = -1;
    return (C_FLUSH);
    }
    
    p = codebuf + (baddr >> 3);
    
    code = ((((p[0] << 8) | p[1]) << 8) | p[2]) << 8;
    code <<= (baddr & 7);
    code >>= 32 - size;
    
    baddr += size;
    
    return (code);
}

/****************************************************************
*
****************************************************************/
void    putcode(unsigned long code, int size)
{
    unsigned char   *p;
    
    if (code == C_FLUSH)
    {   eaddr = (baddr + 7) & ~7;
    baddr = 0;
    codedone = 1;
    return;
    }
    
    if (size == 0)
    {   baddr = (baddr + 7) & ~7;
    codebuf[baddr>>3] = 0;
    return;
    }
    
    if (size != N3 && code == FLUSH && (baddr & 7) == 0)
        return;
    
    p = codebuf + (baddr >> 3);
    code <<= 24 - size - (baddr & 7);
    
    p[2] = code;
    code >>= 8;
    p[1] = code;
    code >>= 8;
    p[0] |= code;
    baddr += size;
}

/****************************************************************
*
****************************************************************/
void    putdata(int data)
{
    if (data == C_FLUSH)
        return;
    
    *eout++ = data;
}

/****************************************************************
*
****************************************************************/
void    init_dict()
{
    struct  dict    *dp;
    unsigned long   data;
    
    for (dp = dict, data = -N6 ; dp < &dict[N2+1] ; dp++, data++)
    {   dp->parent = 0;
    dp->kids = 0;
    dp->sibling = 0;
    dp->data = data;
    }
    
    c1 = N5;    /* reset dictionary to contain only */
    /* control & single character codewords. */
    c2 = N3 + 1;    /* initially set codeword size to 9 bits. */
    c3 = 2 * N4;    /* allow 512 dictionaries entries to start, */
    escape = 0; /* escape char is zero. */
    compress = 0;   /* transparent mode */
    last = 0;
}

/****************************************************************
*
****************************************************************/
unsigned long   search_dict(unsigned long string, unsigned char data)
{
    unsigned long   kid;
    
    /*
    * Search dictionary for string + data.
    * Ignore last entry since it is not yet
    * in the receiver's dictionary.
    */
    if (!string)
        return (data+N6);
    
    for (kid = dict[string].kids ; kid ; kid = dict[kid].sibling)
        if (kid != last && dict[kid].data == data)
            return (kid);
        
        return (0);
}

/****************************************************************
*
****************************************************************/
void    add_dict(unsigned long string, unsigned char data)
{
    struct  dict    *dp;
    unsigned long   kid, prev, me;
    
    if (!string)
        return;
    
        /*
        * add string+data to dictionary
    */
    dp = &dict[c1];
    dp->data = data;
    dp->parent = string;
    dp->kids = 0;
    dp->sibling = dict[string].kids;
    dict[string].kids = c1;
    last = c1;
    dp++;
    
    
    /*
    * free up a dictionary entry
    */
    for (;;)
    {   while (dp->kids)
    dp++;   /* sentinel stops us at end of dict */
    if (dp < &dict[N2])
        break;
    dp = &dict[N5];
    }
    
    c1 = me = dp - dict;
    
    /*
    * remove the entry from parents list of kids
    */
    if (dp->parent)
    {   kid = dict[dp->parent].kids;
    for (prev = 0 ; kid ; prev = kid, kid = dict[kid].sibling)
        if (kid == me)
            break;
        if (prev)
            dict[prev].sibling = dp->sibling;
        else
            dict[dp->parent].kids = dp->sibling;
    }
}

/****************************************************************
*
****************************************************************/
void    checksize_dict()
{
/*
* check codeword size and increase it
* and dictionary size if necessary.
    */
    while (c1 >= c3)
    {   putcode(STEPUP, c2);
    c2++;
    c3 <<= 1;
    }
}

/****************************************************************
*
****************************************************************/
void    encode()
{
    /*    static    unsigned char   str[N7+1]; */
    unsigned long   dp;
    unsigned long   string;
    int     len;
    unsigned long   data;
    int     outbits, inbits;
    int     nosqueeze;
    
    inbits = 0;
    outbits = 0;
    string = 0;
    len = 0;
    nosqueeze = 0;
    
    for (;;)
    {   switch (data = getdata())
    {
    case C_STOP:
    case C_ERROR:
        return;
    case C_INIT:
        init_dict();
        continue;
    case C_FLUSH:
        if (string)
        {   if (compress)
        {   checksize_dict();
        putcode(string, c2);
        putcode(FLUSH, c2);
        }
        }
        putcode(C_FLUSH, 0);
        continue;
    case C_DATA:
    case C_TRANSFER:
        continue;
    default:
        break;
    }
    
    /*
    * periodically test compression
    */
    if (inbits > 8*256)
    {   if (inbits < outbits)
    {   /*
        * if we're not compressing very well,
        * switch to transparent mode until things
        * get better.
        */
        if (compress)
        {   if (string)
        {   checksize_dict();
        putcode(string, c2);
        }
        if (!search_dict(string, data))
            add_dict(string, data);
        putcode(ETM, c2);
        putcode(0, 0);
        compress = 0;
        string = 0;
        len = 0;
        }
        /*
        * If we haven't been compressing very well
        * for a while and the dictioanry has grown,
        * then reset it.
        */
        else if (++nosqueeze >= 5 && c3 > 2*N4)
        {   nosqueeze = 0;
        putcode(escape, N3);
        putcode(RESET, N3);
        init_dict();
        string = 0;
        len = 0;
        }
    }
    /*
    * if we're not compressing but should be,
    * then switch to compress mode.
    */
    else if (!compress)
    {   if (!search_dict(string, data))
    add_dict(string, data);
    putcode(escape, N3);
    putcode(ECM, N3);
    compress = 1;
    string = 0;
    len = 0;
    }
    inbits = 0;
    outbits = 0;
    }
    
    /*
    * process a character
    */
    inbits += 8;
    
    /*
    * always output char if in transparent mode
    */
    if (!compress)
    {   putcode(data, N3);
    if (data == escape)
        putcode(EID, N3);
    }
    
    /*
    * always cycle escape chars
    */
    if (data == escape)
        escape = (escape + 51) % 256;
    
        /*
        * Search dictionary for string+data.
    */
    dp = search_dict(string, data);
    
    /*
    * if string+data is already in dictionary
    * try again with next character.
    */
    if (dp)
    {   string = dp;
    len++;
    continue;
    }
    
    /*
    * Transmit the codeword for the
    * string matched up to this point.
    */
    if (string)
    {   if (compress)
    {   checksize_dict();
    putcode(string, c2);
    }
    }
    
    /*
    * Keep track of compression ratio,
    * whether in transparent mode or not.
    */
    outbits += c2;
    
    /*
    * add string+data to dictionary
    */
    if (len < N7)
        add_dict(string, data);
    
        /*
        * Start a new string consisting of
        * only the unmatched character.
    */
    string = data+N6;
    len = 1;
    }
}

/****************************************************************
*
****************************************************************/
void    decode()
{
    static  unsigned char   str[N7+1];
    unsigned long   dp;
    unsigned long   string;
    unsigned long   code;
    unsigned char   *s;
    
    string = 0;
    
    for (;;)
    {   switch (code = getcode(compress?c2:N3))
    {
        case C_ERROR:
            puts("decode: error code in input stream");
            return;
        case C_STOP:
            return;
        case C_INIT:
            init_dict();
            continue;
        case C_FLUSH:
            putdata(C_FLUSH);
            continue;
        case C_DATA:
        case C_TRANSFER:
            continue;
        default:
            break;
    }
    if (compress)
    {   switch (code)
    {
            case ETM:
                code = getcode(0);
                compress = 0;
                break;
            case FLUSH:
                code = getcode(0);
                putdata(C_FLUSH);
                break;
            case STEPUP:
                c2++;
                c3 <<= 1;
                break;
            default:
                s = &str[N7];
                for (dp = code ; dp ; dp = dict[dp].parent)
                    *--s = dict[dp].data;
                if (!search_dict(string, *s))
                    add_dict(string, *s);
                for ( ; s < &str[N7] ; s++)
                {   putdata(*s);
                if (*s == escape)
                    escape = (escape + 51) % 256;
                }
                string = code;
                break;
    }
    }
    else
    {   if (code == escape)
    {   switch (getcode(N3))
    {
                case ECM:
                    compress = 1;
                    continue;
                case RESET:
                    init_dict();
                    string = 0;
                    continue;
                case EID:
                    break;
                default:
                    puts("decode: escape error input stream");
                    continue;
    }
    escape = (escape + 51) % 256;
    }
    putdata(code);
    
    /*
    * Search dictionary for string+data.
    */
    dp = search_dict(string, code);
    
    /*
    * if string+data is already in dictionary
    * try again with next character.
    */
    if (dp)
    {   string = dp;
    continue;
    }
    
    /*
    * add string+data to dictionary
    */
    add_dict(string, code);
    
    /*
    * Start a new string consisting of
    * only the unmatched character.
    */
    string = code+N6;
    }
    }
}

main(argc, argv)
int argc;
char    *argv[];
{
    unsigned char   *s, *t, *e;
    
    gP=gE=0;
    codedone = baddr = eaddr = escape = compress = 0;
    eout = outbuf;
    encode();
    decode();
    
    /* Error Checking code follows */
    for (s = inbuf, t = outbuf, e = s + sizeof(inbuf) ; s < e ; s++, t++){
        if (*s != *t)
            break;
	}
    if (t != eout) {
        puts("v42: fail\n");
    }
    else {
        puts("v42: success\n");
    }
}
