//
// Copyright (c) 1997-2001 Tony Givargis. Permission to copy is
// granted provided that this header remains intact. This software
// is provided with no warranties.
//

//----------------------------------------------------------------------------

#ifndef psdata_h
#define psdata_h

//-----------------------------------------------------------------------------

const int TotalParameters = 19;
const int MaxPoints = 114;
const int MaxPointsPerParameter = 32;
const int PointsPerParameter[TotalParameters] = {
    
    { 10 }, { 5 }, { 5 },   // I$
    { 10 }, { 5 }, { 5 },   // D$
    {  4 }, { 3 },          // CPU-I$-DBUS
    {  4 }, { 3 },          // CPU-I$-ABUS
    {  4 }, { 3 },          // CPU-D$-DBUS
    {  4 }, { 3 },          // CPU-D$-ABUS
    {  4 }, { 3 },          // I/D$-MEM-DBUS
    {  4 }, { 3 },          // I/D$-MEM-ABUS
    { 32 }                  // Voltage
};

//-----------------------------------------------------------------------------

class ParameterSpaceData {
    
public:
    bool space[TotalParameters][MaxPointsPerParameter];
    
public:
    ParameterSpaceData();
    ~ParameterSpaceData();
};

//-----------------------------------------------------------------------------

#endif