//
// Copyright (c) 1997-2001 Tony Givargis. Permission to copy is
// granted provided that this header remains intact. This software
// is provided with no warranties.
//

//----------------------------------------------------------------------------

#include "resource.h"
#include "psdlg.h"

//----------------------------------------------------------------------------

ParameterSpaceDialog::ParameterSpaceDialog(CWnd *parent,
                                           ParameterSpaceData *_psData) 
                                           : CDialog(IDD_DIALOG2, parent) {
    
    psData = _psData;
}

//----------------------------------------------------------------------------

ParameterSpaceDialog::~ParameterSpaceDialog() {
}

//----------------------------------------------------------------------------

void ParameterSpaceDialog::DoDataExchange(CDataExchange *dx) {
    
    int count = 0;
    
    CDialog::DoDataExchange(dx);
    
    for(int i=0; i<TotalParameters; i++) {
        
        for(int j=0; j<PointsPerParameter[i]; j++) {
            
            DDX_Control(dx, IDC_CHECK1 + count,  check[count]);
            count++;
        }
    }
}

//----------------------------------------------------------------------------

BOOL ParameterSpaceDialog::OnInitDialog() {
    
    int count = 0;
    
    if( CDialog::OnInitDialog() ) {
        
        for(int i=0; i<TotalParameters; i++) {
            
            for(int j=0; j<PointsPerParameter[i]; j++) {
                
                check[count].SetCheck(psData->space[i][j] ? 1 : 0);
                count++;
            }
        }
        return true;
    }
    return false;
}

//----------------------------------------------------------------------------

void ParameterSpaceDialog::OnOK() {
    
    int count = 0;
    
    for(int i=0; i<TotalParameters; i++) {
        
        for(int j=0; j<PointsPerParameter[i]; j++) {
            
            psData->space[i][j] = check[count].GetCheck() ? true : false;
            count++;
        }
    }
    for(i=0; i<TotalParameters; i++) {
        
        count = 0;
        for(int j=0; j<PointsPerParameter[i]; j++) {
            
            if( psData->space[i][j] ) {
                
                count = 1;
                break;
            }
        }
        if( !count ) {
            
            MessageBox("Some of the parameters are undefined!", 0, MB_ICONHAND);
            return;
        }
    }
    CDialog::OnOK();
}

//----------------------------------------------------------------------------

void ParameterSpaceDialog::OnClrAll() {
    
    int count = 0;
    
    if( CDialog::OnInitDialog() ) {
        
        for(int i=0; i<TotalParameters; i++) {
            
            for(int j=0; j<PointsPerParameter[i]; j++) {
                
                check[count].SetCheck(0);
                count++;
            }
        }
    }
}

//----------------------------------------------------------------------------

void ParameterSpaceDialog::OnSetAll() {
    
    int count = 0;
    
    if( CDialog::OnInitDialog() ) {
        
        for(int i=0; i<TotalParameters; i++) {
            
            for(int j=0; j<PointsPerParameter[i]; j++) {
                
                check[count].SetCheck(1);
                count++;
            }
        }
    }
}

//----------------------------------------------------------------------------

BEGIN_MESSAGE_MAP(ParameterSpaceDialog, CDialog)
ON_COMMAND(IDC_BUTTON1, OnClrAll)
ON_COMMAND(IDC_BUTTON2, OnSetAll)
END_MESSAGE_MAP()