//
// Copyright (c) 1997-2001 Tony Givargis. Permission to copy is
// granted provided that this header remains intact. This software
// is provided with no warranties.
//

//----------------------------------------------------------------------------

#include "tech.h"

//----------------------------------------------------------------------------

double Tech = .18e-6;
double CapTran = 1e-13;
double CapWire = 1e-12;
double AvgBusWireLen = 3e-8;
double ThreshVoltage = .8;

//----------------------------------------------------------------------------

double ComputeMemoryPower(unsigned traffic, double voltage) {
    
    double p;
    
    p = 1024 * CapTran;
    p = p * voltage * voltage * 0.5;
    return p * traffic;
}

//----------------------------------------------------------------------------

double ComputeClockSpeed(double voltage) {
    
	double t = (voltage - ThreshVoltage);

    return ((t * t) / voltage) * 100e6;
}