//
// Copyright (c) 1997-2001 Tony Givargis. Permission to copy is
// granted provided that this header remains intact. This software
// is provided with no warranties.
//

//-----------------------------------------------------------------------------

#include <afxwin.h>
#include "thread.h"

//-----------------------------------------------------------------------------

Thread::Thread() : handle(0) {
}

//-----------------------------------------------------------------------------

Thread::~Thread() {
    
    Stop();
}

//-----------------------------------------------------------------------------

bool Thread::IsRunning() const {
    
    return handle != 0;
}

//-----------------------------------------------------------------------------

bool Thread::Start() {
    
    DWORD notUsed;
    LPTHREAD_START_ROUTINE psr;
    
    psr = reinterpret_cast<LPTHREAD_START_ROUTINE>(run_thread);
    if( !handle ) {
        
        handle = CreateThread(0, 0, psr, this, 0, &notUsed);
        SetThreadPriority(handle, THREAD_PRIORITY_LOWEST);
    }
    return handle == 0 ? false : true;
}

//-----------------------------------------------------------------------------

void Thread::Stop() {
    
    if( handle ) {
        
        TerminateThread(handle, 0);
        handle = 0;
    }
}

//-----------------------------------------------------------------------------

void *run_thread(void *arg) {
    
    reinterpret_cast<Thread*>(arg)->Run(); 
    reinterpret_cast<Thread*>(arg)->handle = 0; 
    return 0;
}